<?php $__env->startSection('title', 'View All Courses'); ?>

<?php $__env->startSection('subTitle', 'All Course Trainers Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.coursetrainers.create')); ?>" class="btn btn-success">Add New Course Trainer</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
					<?php if($message = Session::get('success')): ?>
					<div class="alert alert-success alert-block">
						<button type="button" class="close" data-dismiss="alert">×</button>
						<strong><?php echo e($message); ?></strong>
					</div>
					<?php endif; ?>
					<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead class="thead-default">
								<tr>
									<th>#</th>
									<th>Name</th>
									<th class="d-none">Mobile</th>
									<th class="d-none">Email</th>
									<th class="d-none">Photo</th>
									<th>Updated By</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
								<?php if(count($courseTrainers)): ?>
									<?php $__currentLoopData = $courseTrainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseTrainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<th scope="row"><?php echo e($courseTrainer->id); ?></th>
										<td><?php echo e($courseTrainer->name); ?></td>
										<td class="d-none"><?php echo e($courseTrainer->mobile); ?></td>
										<td class="d-none"><?php echo e($courseTrainer->email); ?></td>
										<td class="d-none"><img src="<?php echo e(asset('img/courses/trainer/'.$courseTrainer->photo)); ?>" alt="<?php echo e($courseTrainer->name); ?>" width="128" heigt="128"></td>
										<td><?php echo e($courseTrainer->editedBy ? $courseTrainer->editedBy->name : 'N/A'); ?></td>
										<td class="text-center d-flex justify-content-center">
											<a href="<?php echo e(route('admin.coursetrainers.edit',$courseTrainer->id)); ?>" class="btn btn-warning">Edit</a>
											<form action="<?php echo e(route('admin.coursetrainers.destroy',$courseTrainer->id)); ?>" method="post">
												<?php echo csrf_field(); ?>
												<input type="hidden" name="_method" value="DELETE">
												<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
											</form>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php endif; ?>
							</tbody>
						</table>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>