<?php $__env->startSection('content'); ?>
<div class="individual-course-details">
		<div class="container">
			<h1 class="individual-course-details-title text-center">Course Details</h1>
			<div class="row no-gutters">
				<div class="col-md-8 individual-course-col">
					<h1><?php echo e($course->title); ?></h1>
					<span class="border-title"></span>
					<div class="description">
						<?php echo $course->description; ?>

					</div>
				</div>
				<div class="col-md-4 individual-course-col">
					<div class="individual-course-details-price-wrapper">
						<h2 class="price-text d-none">Price: <span class="price-amount">Tk. <?php echo e($course->price); ?></span></b></h2>
						<div class="reg-btn-wrapper">
							<a href="<?php echo e(route('seminar.register')); ?>" class="reg-btn">
								Register
							</a>
						</div>
						<div class="contact-wrapper">
							<h3 class="contact-text">
								Contact
							</h3>
							<p class="contact">
								Call: <?php echo e($course->contact_mobile); ?>

							</p>
							<p class="contact">
								Email: <a href="mailto:<?php echo e($course->contact_email); ?>"><?php echo e($course->contact_email); ?></a>
							</p>
						</div>
					</div>
					<div class="individual-course-info-wrapper">
						<h4 class="course-shortinfo-title">Course Information</h4>
						<span class="border-title"></span>
						<p><span class="course-info-subtitle"><i class="far fa-calendar-check"></i> Date :</span> <?php echo e($courseEvent->start_date->format('d M')); ?> - <?php echo e($courseEvent->end_date->format('d M Y')); ?></p>
						<p><span class="course-info-subtitle"><i class="fas fa-list-ul"></i> No. of Classes :</span> <?php echo e($courseEvent->total_no_of_class); ?></p>
						<p><span class="course-info-subtitle"><i class="far fa-clock"></i> Total Hours :</span> <?php echo e($courseEvent->total_hours); ?></p>
						<p><span class="course-info-subtitle"><i class="far fa-calendar-times"></i> Last Date of Registration :</span> <?php echo e($courseEvent->last_date_of_reg->format('d M Y')); ?></p>
						<p><span class="course-info-subtitle"><i class="fas fa-list-ul"></i> Instructor :</span> <?php echo e($courseEvent->courseTrainer->name); ?></p>
						<p><span class="course-info-subtitle"><i class="far fa-calendar-alt"></i> Class Schedule :</span></p>
						<div class="class-schedule">
							<?php $__currentLoopData = $courseEvent->schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseSchedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<p><?php echo e($courseSchedule->day); ?> - <?php echo e($courseSchedule->start_time->format('h:m A')); ?> - <?php echo e($courseSchedule->end_time->format('h:m A')); ?></p>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>