

<?php $__env->startSection('title', 'Add New SubCategory'); ?>

<?php $__env->startSection('subTitle', 'Add new subcategory as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.subcategories')); ?>" class="btn btn-danger">View All SubCategories</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header"><?php echo e(__('Add New SubCategory')); ?></div>

                <div class="card-body">
                        <?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>
                    <form method="POST" action="<?php echo e(route('admin.subcategories.store')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="form-group row">
                            <label for="name" class="col-md-4 col-form-label text-md-right"><?php echo e(__('Name')); ?></label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control<?php echo e($errors->has('name') ? ' is-invalid' : ''); ?>" name="name" value="<?php echo e(old('name')); ?>" required autofocus>

                                <?php if($errors->has('name')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('name')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="description" class="col-md-4 col-form-label text-md-right"><?php echo e(__('Description')); ?></label>

                            <div class="col-md-6">
                                <textarea class="form-control<?php echo e($errors->has('description') ? ' is-invalid' : ''); ?>" name="description" id="description" rows="2"><?php echo e(old('description') ? old('description') : 'N/A'); ?></textarea>

                                <?php if($errors->has('description')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('description')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="category_id" class="col-md-4 col-form-label text-md-right"><?php echo e(__('Category Name')); ?></label>

                            <div class="col-md-6">
                                <select id="category_id" class="form-control<?php echo e($errors->has('category_id') ? ' is-invalid' : ''); ?>" name="category_id" required>
                                    <?php if(count($categories)): ?>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php echo e($key==0 ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>

                                <?php if($errors->has('category_id')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('category_id')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>



                        <div class="form-group row">
                            <label for="haschildcategory" class="col-md-4 col-form-label text-md-right"><?php echo e(__('Has ChildCategory')); ?></label>

                            <div class="col-md-6">
                                <select id="haschildcategory" class="form-control<?php echo e($errors->has('haschildcategory') ? ' is-invalid' : ''); ?>" name="haschildcategory" required>
                                    <option value="1" selected>Yes</option>
                                    <option value="0">No</option>
                                </select>

                                <?php if($errors->has('haschildcategory')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('haschildcategory')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="order" class="col-md-4 col-form-label text-md-right"><?php echo e(__('Order')); ?></label>

                            <div class="col-md-6">
                                <input id="order" type="number" class="form-control<?php echo e($errors->has('order') ? ' is-invalid' : ''); ?>" name="order" value="<?php echo e(old('order') ? old('order') : 1); ?>" required>

                                <?php if($errors->has('order')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('order')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                        <div class="col-md-4"></div>
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    <?php echo e(__('Add')); ?>

                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>