<?php $__env->startSection('title', 'View All Courses'); ?>

<?php $__env->startSection('subTitle', 'All Courses Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.courses.create')); ?>" class="btn btn-success">Add New Course</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
					<?php if($message = Session::get('success')): ?>
					<div class="alert alert-success alert-block">
						<button type="button" class="close" data-dismiss="alert">×</button>
						<strong><?php echo e($message); ?></strong>
					</div>
					<?php endif; ?>
					<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead class="thead-default">
								<tr>
									<th>#</th>
									<th>Title</th>
									<th>Price</th>
									<th>Image</th>
									<th>Short Description</th>
									<th>Updated By</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
								<?php if(count($courses)): ?>
									<?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<th scope="row"><?php echo e($course->id); ?></th>
										<td><?php echo e($course->title); ?></td>
										<td><?php echo e($course->price); ?></td>
										<td><img src="<?php echo e(asset('img/courses/feature/'.$course->image)); ?>" alt="<?php echo e($course->title); ?>" width="128" heigt="128"></td>
										<td><?php echo e($course->excerpt); ?></td>
										<td><?php echo e($course->editedBy ? $course->editedBy->name : 'N/A'); ?></td>
										<td class="text-center d-flex justify-content-center">
											<a href="<?php echo e(route('courses.show',$course->slug)); ?>" class="btn btn-success">View</a>
											<a href="<?php echo e(route('admin.courses.edit',$course->slug)); ?>" class="btn btn-warning">Edit</a>
											<form action="<?php echo e(route('admin.courses.destroy',$course->slug)); ?>" method="post">
												<?php echo csrf_field(); ?>
												<input type="hidden" name="_method" value="DELETE">
												<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
											</form>
										</td>
									</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php endif; ?>
							</tbody>
						</table>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>