<?php $__env->startSection('content'); ?>
<div class="upcoming-courses">
		<div class="container">
			<h1 class="upcoming-courses-title text-center"><?php echo e($pageTitle ? $pageTitle : 'No Title Available'); ?></h1>
			<div class="row no-gutters">
				<?php $__currentLoopData = $courseEvents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courseEvent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<div class="col-md-3 upcoming-col">
					<div class="card mx-auto" style="width:270px;">
						<div class="card-header bg-transparent">
							<div class="flip">
								<div class="front">
									<img src="<?php echo e(asset('img/courses/feature/'.$courseEvent->course->image)); ?>" class="img-fluid" alt="<?php echo e($courseEvent->course->title); ?>" />
								</div>
								<div class="back">
									<div>
										<a href="<?php echo e(route('courseEvents.show',[$courseEvent->course->slug,$courseEvent->id])); ?>" class="about-button" role="button" aria-pressed="true">View Details</a>
									</div>
								</div>
							</div>
						</div>
						<div class="card-body text-success">
							<h5 class="card-title">
								<a href="<?php echo e(route('courseEvents.show',[$courseEvent->course->slug,$courseEvent->id])); ?>" class="course-title"><?php echo e($courseEvent->course->title); ?></a>
							</h5>
							<span class="short-line"></span>

							<ul class="course-info">
								<li>
									<i class="far fa-calendar"></i>
									<?php echo e($courseEvent->start_date->format('d M Y')); ?> - <?php echo e($courseEvent->end_date->format('d M Y')); ?>

								</li>
								<li>
									<i class="far fa-clock"></i>
									Total Hours : <?php echo e($courseEvent->total_hours); ?>

								</li>
							</ul>
						</div>
						<div class="card-footer bg-transparent">
							<div class="price-block d-flex justify-content-around">
								<span class="price d-none">Tk. <?php echo e($courseEvent->course->price); ?></span>
								<span class="course-reg-btn"><a href="<?php echo e(route('seminar.register')); ?>">Enroll Now</a></span>
							</div>
						</div>
					</div>
				</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>