<?php $__env->startSection('title', 'Edit a News'); ?>

<?php $__env->startSection('subTitle', 'Edit a news as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.news.index')); ?>" class="btn btn-success">View All News</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						<?php if($message = Session::get('success')): ?>
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
						<?php endif; ?>

						<?php if(count($errors) > 0): ?>
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<li><?php echo e($error); ?></li>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</ul>
						</div>
						<?php endif; ?>
						<form action="<?php echo e(route('admin.news.update',$news->slug)); ?>" method="POST" enctype="multipart/form-data">
							<?php echo csrf_field(); ?>
							<input type="hidden" name="_method" value="PUT">
							<div class="form-group">
								<label for="title">Title</label>
								<input type="text" class="form-control" id="title" name="title" value="<?php echo e(old('name') ? old('name') : $news->title); ?>" required>
							</div>
							<div class="form-group">
								<label for="image">Photo (Leave empty if No image change Needed)</label>
								<div><img src="/img/news/<?php echo e($news->image); ?>" alt=""  width="200" height="100"></div>
								<br>
								<input type="file" class="form-control-file" id="image" name="image">
							</div>
							<div class="form-group">
								<label for="shortdescription">Short Description (Maximun 160 Characters)</label>
								<textarea class="form-control" id="shortdescription" maxlength="160" name="shortdescription"  value="" rows="2"  required><?php echo e($news->excerpt); ?></textarea>
							</div>
							<div class="form-group">
								<label for="longdescription">Long Description (Maximun 2000 Characters)</label>
								<textarea class="form-control summernote" id="longdescription" maxlength="2000" name="longdescription"  rows="6" cols="80"  required><?php echo e($news->description); ?></textarea>
							</div>
							<div class="form-group">
								<label for="order">Position</label>
								<input type="text" class="form-control" id="order" name="order" value="<?php echo e(old('order') ? old('order') : $news->order); ?>" required>
							</div>
							<br>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>