<?php $__env->startSection('title', 'View All News'); ?>

<?php $__env->startSection('subTitle', 'All News Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.news.create')); ?>" class="btn btn-success">Add New News</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
						<div class="row gutters">
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="card">
									<div class="card-body">
											<?php if($message = Session::get('success')): ?>
											<div class="alert alert-success alert-block">
												<button type="button" class="close" data-dismiss="alert">×</button>
												<strong><?php echo e($message); ?></strong>
											</div>
											<?php endif; ?>
										<div class="table-responsive">
											<table class="table table-bordered table-hover">
												<thead class="thead-default">
													<tr>
														<th>#</th>
														<th>Title</th>
														<th>Image</th>
														<th>Short Description</th>
														<th>Actions</th>
													</tr>
												</thead>
												<tbody>
												<?php if(count($news)): ?>
													<?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $singleNews): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<th scope="row"><?php echo e($singleNews->id); ?></th>
														<td><?php echo e($singleNews->title); ?></td>
														<td><img src="/img/news/<?php echo e($singleNews->image); ?>" alt="<?php echo e($singleNews->title); ?>" width="100" height=""></td>
														<td><?php echo e($singleNews->excerpt); ?></td>
														<td class="text-center d-flex justify-content-center">
															<a href="/news/<?php echo e($singleNews->slug); ?>" class="btn btn-primary">View</a>
															<a href="<?php echo e(route('admin.news.edit',$singleNews->slug)); ?>" class="btn btn-warning">Edit</a>
															<form action="<?php echo e(route('admin.news.destroy',$singleNews->slug)); ?>" method="post">
																<?php echo csrf_field(); ?>
																<input type="hidden" name="_method" value="DELETE">
																<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
															</form>
														</td>
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php endif; ?>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
		<?php if($flash = session('message')): ?>
			<div id="flash-message" class="alert alert-success" role="alert">
				<?php echo e($flash); ?>

			</div>
	<?php endif; ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>