

<?php $__env->startSection('title', 'Edit a Important Link'); ?>

<?php $__env->startSection('subTitle', 'Edit a link as much you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.important-links.index')); ?>" class="btn btn-success">View All Important Links</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                        <?php if($message = Session::get('success')): ?>
						<div class="alert bg-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong><?php echo e($message); ?></strong>
						</div>
                        <?php endif; ?>
						<?php if(count($errors) > 0): ?>
						<div class="alert alert-danger">
                            <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
						</div>
						<?php endif; ?>
                        <form method="POST" action="<?php echo e(route('admin.important-links.update',$importantLink->id)); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="form-group">
                                <label for="title" class="col-md-12 col-form-label"><?php echo e(__('Title')); ?></label>

                                <div class="col-md-12">
                                    <input id="title" type="text" class="form-control<?php echo e($errors->has('title') ? ' is-invalid' : ''); ?>" name="title" value="<?php echo e(old('title') ? old('title') : $importantLink->title); ?>" required>

                                    <?php if($errors->has('title')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('title')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>

                             <div class="form-group">
                            <label for="url" class="col-md-12 col-form-label"><?php echo e(__('Url')); ?></label>

                            <div class="col-md-12">
                                <input id="url" type="text" class="form-control<?php echo e($errors->has('url') ? ' is-invalid' : ''); ?>" name="url"  value="<?php echo e(old('title') ? old('url') : $importantLink->url); ?>" required>

                                <?php if($errors->has('url')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('url')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                         <div class="form-group">
                            <label for="priority" class="col-md-12 col-form-label"><?php echo e(__('Position')); ?></label>

                            <div class="col-md-12">
                                <input id="priority" type="number" class="form-control<?php echo e($errors->has('priority') ? ' is-invalid' : ''); ?>" name="priority"  value="<?php echo e(old('priority') ? old('priority') : $importantLink->priority); ?>" required>

                                <?php if($errors->has('priority')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('priority')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                            <div class="form-group mb-0">
                                <div class="col-md-12"></div>
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary">
                                            <?php echo e(__('Update ')); ?>

                                        </button>
                                    </div>
                            </div>
                        </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>