<?php $__env->startSection('title', 'Add New Course'); ?>

<?php $__env->startSection('subTitle', 'Add new course as mush you need.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.courses.index')); ?>" class="btn btn-success">View All Courses</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <?php if($message = Session::get('success')): ?>
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <strong><?php echo e($message); ?></strong>
                    </div>
                    <?php endif; ?>

                    <?php if(count($errors) > 0): ?>
                    <div class="alert alert-danger">
                        <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
                    </div>
                    <?php endif; ?>
                    <form method="POST" action="<?php echo e(route('admin.courses.store')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="form-group">
                            <label for="title" class="col-md-12 col-form-label"><?php echo e(__('Title')); ?></label>

                            <div class="col-md-12">
                                <input id="title" type="text" class="form-control<?php echo e($errors->has('title') ? ' is-invalid' : ''); ?>" name="title" value="<?php echo e(old('title')); ?>" required>

                                <?php if($errors->has('title')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('title')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="price" class="col-md-12 col-form-label"><?php echo e(__('Course Fee')); ?></label>

                            <div class="col-md-12">
                                <input id="price" type="text" class="form-control<?php echo e($errors->has('price') ? ' is-invalid' : ''); ?>" name="price" value="<?php echo e(old('price')); ?>"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" required>
                                <?php if($errors->has('price')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('price')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                                <label for="contact_mobile" class="col-md-12 col-form-label text-md-left"><?php echo e(__('Contact Mobile No.')); ?></label>

                                <div class="col-md-12">
                                        <input id="contact_mobile" type="text" class="form-control<?php echo e($errors->has('contact_mobile') ? ' is-invalid' : ''); ?>" name="contact_mobile" value="<?php echo e(old('contact_mobile')); ?>" required>

                                    <?php if($errors->has('contact_mobile')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('contact_mobile')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>

                        <div class="form-group">
                                <label for="contact_email" class="col-md-12 col-form-label text-md-left"><?php echo e(__('Contact Email No.')); ?></label>

                                <div class="col-md-12">
                                        <input id="contact_email" type="text" class="form-control<?php echo e($errors->has('contact_email') ? ' is-invalid' : ''); ?>" name="contact_email" value="<?php echo e(old('contact_email')); ?>" required>

                                    <?php if($errors->has('contact_email')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('contact_email')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>

                        <div class="form-group">
                            <label for="excerpt" class="col-md-12 col-form-label"><?php echo e(__('Front Page Short Description (Max Length: 100 characters)')); ?></label>

                            <div class="col-md-12">
                                <textarea class="form-control<?php echo e($errors->has('excerpt') ? ' is-invalid' : ''); ?>" name="excerpt" maxlength="100" id="excerpt" rows="3"><?php echo e(old('excerpt')); ?></textarea>

                                <?php if($errors->has('excerpt')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('excerpt')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description" class="col-md-12 col-form-label"><?php echo e(__('Description')); ?></label>

                            <div class="col-md-12">
                                <textarea class="form-control<?php echo e($errors->has('description') ? ' is-invalid' : ''); ?>" name="description" id="description" rows="3"><?php echo e(old('description')); ?></textarea>

                                <?php if($errors->has('description')): ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($errors->first('description')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="featured_image" class="col-md-12 col-form-label"><?php echo __('Featured Image <small>(Max Size:1.5MB, Dimensions: 360x319)</small>'); ?></label>

                            <div class="col-md-12">
                                <input type="file" class="form-control-file<?php echo e($errors->has('featured_image') ? ' is-invalid' : ''); ?>" id="featured_image" name="featured_image" value="<?php echo e(old('featured_image') ? old('featured_image') : ''); ?>">

                                <?php if($errors->has('featured_image')): ?>
                                    <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                        <strong><?php echo e($errors->first('featured_image')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group" style="display:none;">
                                <label for="slug" class="col-md-12 col-form-label text-danger font-weight-bold"><?php echo e(__('URL Optional')); ?> <span class="text-danger">
                                        (Only alphanumeric characters and hyphen is applicable.)
                                    </span></label>

                                <div class="col-md-12">
                                    <input id="slug" type="text" class="form-control is-invalid" name="slug" value="<?php echo e(old('slug')); ?>">

                                    <?php if($errors->has('slug')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('slug')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>

                        <div class="form-group" style="display:none;">
                                <label for="order" class="col-md-12 col-form-label"><?php echo e(__('Position')); ?></label>

                                <div class="col-md-12">
                                    <input id="order" type="number" class="form-control<?php echo e($errors->has('order') ? ' is-invalid' : ''); ?>" name="order" value="<?php echo e(old('order') ? old('order') : 1); ?>" required>

                                    <?php if($errors->has('order')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('order')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                        </div>

                        <div class="form-group mb-0">
                            <div class="col-md-12"></div>
                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Add Course')); ?>

                                    </button>
                                </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>