<?php $__env->startSection('title', 'View All Galleries'); ?>

<?php $__env->startSection('subTitle', 'All Galleries Information is Available Here.'); ?>

<?php $__env->startSection('button'); ?>
	<a href="<?php echo e(route('admin.galleries.create')); ?>" class="btn btn-success">Add New Gallery Image</a>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
<div class="row gutters">
	<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
		<div class="card">
			<div class="card-body">
				<?php if($message = Session::get('success')): ?>
				<div class="alert alert-success alert-block">
					<button type="button" class="close" data-dismiss="alert">×</button>
					<strong><?php echo e($message); ?></strong>
				</div>
				<?php endif; ?>
				<div class="table-responsive">
				<table class="table table-bordered table-hover">
					<thead class="thead-default">
						<tr>
							<th>#</th>
							<th>Name</th>
							<th>Type</th>
							<th>Image</th>
							<th>Order</th>
							<th>Actions</th>
						</tr>
					</thead>
					<tbody>
					<?php if(count($galleries)): ?>
						<?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<th scope="row"><?php echo e($gallery->id); ?></th>
							<td><?php echo e($gallery->title); ?></td>
							<td><?php echo e($gallery->type); ?></td>
							<td><img src="<?php echo e(asset('img/gallery/'.$gallery->type.'/'.$gallery->url)); ?>" alt="<?php echo e($gallery->slug); ?>" width="100" height=""></td>
							<td><?php echo e($gallery->order); ?></td>
							<td class="text-center d-flex justify-content-center">
								<a href="<?php echo e(route('admin.galleries.edit',$gallery->slug)); ?>" class="btn btn-warning">Edit</a>
								<form action="<?php echo e(route('admin.galleries.destroy',$gallery->slug)); ?>" method="post">
									<?php echo csrf_field(); ?>
									<input type="hidden" name="_method" value="DELETE">
									<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
								</form>
							</td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
					</tbody>
				</table>
				</div>
			</div>
		</div>
	</div>
</div>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>