<?php
use Illuminate\Http\Request;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::prefix('/')->group(function () {
    // Matches The "/admin/users" URL prefix('admin')

    /*--------------------------------
    Auth Routes
    --------------------------------*/
    Auth::routes();

    /*--------------------------------
    Unisharp FileManager
    --------------------------------*/
    Route::group(['prefix' => 'laravel-filemanager', 'middleware' => ['web', 'auth']], function () {
        \UniSharp\LaravelFilemanager\Lfm::routes();
    });

    /*--------------------------------
    Home Route
    --------------------------------*/
    Route::put('/change-language', 'IndexController@setLocale')->name('setLocale');

    Route::get('/', 'IndexController@index')->name('home');
    Route::redirect('home', '/', 301);
    Route::get('upcoming-courses','CourseController@upcoming')->name('courses.upcoming');
    Route::get('ongoing-courses','CourseController@ongoing')->name('courses.ongoing');
    Route::get('courses/{course}','CourseController@show')->name('courses.show');
    Route::get('courses/{course}/{courseEvent}','CourseController@showEvents')->name('courseEvents.show');
    Route::get('news/','NewsController@index')->name('news.index');
    Route::get('news/{news}','NewsController@show')->name('news.show');
    Route::get('gallery','GalleryController@gallery')->name('galleries.gallery');
    Route::get('testimonials','GalleryController@testimonials')->name('galleries.testimonials');
    Route::get('contact-us','OtherController@contact')->name('contacts.index');
    Route::post('contact-us','OtherController@send')->name('contacts.send');
    Route::get('upload-cv','OtherController@uploadCV')->name('upload-cv.index');
    Route::post('upload-cv','OtherController@sendCV')->name('upload-cv.send');
    Route::get('register-for-an-upcoming-seminar','SeminarController@register')->name('seminar.register');
    Route::post('register-for-an-upcoming-seminar','SeminarController@send')->name('seminar.sendInfo');
    Route::post('upload-cv','OtherController@sendCV')->name('upload-cv.send');
    Route::get('course-details',function(){
        return view('frontend.courses.static');
    });


    /*--------------------------------
        Admin Panel Route
    --------------------------------*/
    Route::prefix('admin')
    ->namespace('Admin')
    // Controllers Within The "App\Http\Controllers\Admin" Namespace
    ->name('admin.')
    ->middleware(['auth', 'checkRole'])
    ->group(function () {
        /*--------------------------------
        Admin Dashboard
        --------------------------------*/
        Route::get('/', 'AdminController@index')->name('index');
        /*--------------------------------
        Admin Categories Route
        --------------------------------*/
        // Add New Category
        Route::get('/categories/create', 'CategoryController@create')->name('categories.create');
        // Store New Category
        Route::post('/categories', 'CategoryController@store')->name('categories.store');
        // View all Category
        Route::get('/categories', 'CategoryController@index')->name('categories.index');
        // View a single Category
        Route::get('/categories/{category}', 'CategoryController@show')->name('categories.show');
        // Edit a Category
        Route::get('/categories/{category}/edit', 'CategoryController@edit')->name('categories.edit');
        // Update a Category
        Route::put('/categories/{category}', 'CategoryController@update')->name('categories.update');
        // Delete a Category
        Route::delete('/categories/{category}', 'CategoryController@destroy')->name('categories.destroy');

        /*--------------------------------
        Admin SubCategories Route
        --------------------------------*/
        // Add New SubCategory
        Route::get('/subcategories/create', 'SubCategoryController@create')->name('subcategories.create');
        // Store New SubCategory
        Route::post('/subcategories', 'SubCategoryController@store')->name('subcategories.store');
        // View all SubCategory
        Route::get('/subcategories', 'SubCategoryController@index')->name('subcategories.index');
        // View a single SubCategory
        Route::get('/subcategories/{subcategory}', 'SubCategoryController@show')->name('subcategories.show');
        // Edit a SubCategory
        Route::get('/subcategories/{subcategory}/edit', 'SubCategoryController@edit')->name('subcategories.edit');
        // Update a SubCategory
        Route::put('/subcategories/{subcategory}', 'SubCategoryController@update')->name('subcategories.update');
        // Delete a SubCategory
        Route::delete('/subcategories/{subcategory}', 'SubCategoryController@destroy')->name('subcategories.destroy');

        /*--------------------------------
        Admin SubChildCategories Route
        --------------------------------*/
        // Add New SubChildCategory
        Route::get('/subchildcategories/create', 'SubChildCategoryController@create')->name('subchildcategories.create');
        // Store New SubChildCategory
        Route::post('/subchildcategories', 'SubChildCategoryController@store')->name('subchildcategories.store');
        // View all SubChildCategory
        Route::get('/subchildcategories', 'SubChildCategoryController@index')->name('subchildcategories.index');
        // View a single SubChildCategory
        Route::get('/subchildcategories/{subchildcategory}', 'SubChildCategoryController@show')->name('subchildcategories.show');
        // Edit a SubChildCategory
        Route::get('/subchildcategories/{subchildcategories}/edit', 'SubChildCategoryController@edit')->name('subchildcategories.edit');
        // Update a SubChildCategory
        Route::put('/subchildcategories/{subchildcategory}', 'SubChildCategoryController@update')->name('subchildcategories.update');
        // Delete a SubChildCategory
        Route::delete('/subchildcategories/{subchildcategory}', 'SubChildCategoryController@destroy')->name('subchildcategories.destroy');


        /*--------------------------------
        Admin Products Route
        --------------------------------*/
        // Add New Product
        Route::get('/products/create', 'ProductController@create')->name('products.create');
        // Store New Product
        Route::post('/products', 'ProductController@store')->name('products.store');
        // View all Product
        Route::get('/products', 'ProductController@index')->name('products.index');
        // View a single Product
        Route::get('/products/{product}', 'ProductController@show')->name('products.show');
        // Edit a Product
        Route::get('/products/{product}/edit', 'ProductController@edit')->name('products.edit');
        // Update a Product
        Route::put('/products/{product}', 'ProductController@update')->name('products.update');
        // Delete a Product
        Route::delete('/products/{product}', 'ProductController@destroy')->name('products.destroy');

        /*--------------------------------
        Admin Courses Route
        --------------------------------*/
        // Add New Course
        Route::get('/courses/create', 'CourseController@create')->name('courses.create');
        // Store New Course
        Route::post('/courses', 'CourseController@store')->name('courses.store');
        // View all Course
        Route::get('/courses', 'CourseController@index')->name('courses.index');
        // View a single Course
        Route::get('/courses/{course}', 'CourseController@show')->name('courses.show');
        // Edit a Course
        Route::get('/courses/{course}/edit', 'CourseController@edit')->name('courses.edit');
        // Update a Course
        Route::put('/courses/{course}', 'CourseController@update')->name('courses.update');
        // Delete a Course
        Route::delete('/courses/{course}', 'CourseController@destroy')->name('courses.destroy');

        /*--------------------------------
        Admin Course Trainer Route
        --------------------------------*/
        // Add New Course
        Route::get('/course-trainers/create', 'CourseTrainerController@create')->name('coursetrainers.create');
        // Store New Course
        Route::post('/course-trainers', 'CourseTrainerController@store')->name('coursetrainers.store');
        // View all Course
        Route::get('/course-trainers', 'CourseTrainerController@index')->name('coursetrainers.index');
        // View a single Course
        Route::get('/course-trainers/{courseTrainer}', 'CourseTrainerController@show')->name('coursetrainers.show');
        // Edit a Course
        Route::get('/course-trainers/{courseTrainer}/edit', 'CourseTrainerController@edit')->name('coursetrainers.edit');
        // Update a Course
        Route::put('/course-trainers/{courseTrainer}', 'CourseTrainerController@update')->name('coursetrainers.update');
        // Delete a Course
        Route::delete('/course-trainers/{courseTrainer}', 'CourseTrainerController@destroy')->name('coursetrainers.destroy');

        /*--------------------------------
        Admin Courses Events Route
        --------------------------------*/
        // Add New Course
        Route::get('/course-events/create', 'CourseEventController@create')->name('courseEvents.create');
        // Store New Course
        Route::post('/course-events', 'CourseEventController@store')->name('courseEvents.store');
        // View all Course
        Route::get('/course-events', 'CourseEventController@index')->name('courseEvents.index');
        // View a single Course
        Route::get('/course-events/{courseEvent}', 'CourseEventController@show')->name('courseEvents.show');
        // Edit a Course
        Route::get('/course-events/{courseEvent}/edit', 'CourseEventController@edit')->name('courseEvents.edit');
        // Update a Course
        Route::put('/course-events/{courseEvent}', 'CourseEventController@update')->name('courseEvents.update');
        // Delete a Course
        Route::delete('/course-events/{courseEvent}', 'CourseEventController@destroy')->name('courseEvents.destroy');



        /*--------------------------------
        Admin News Route
        --------------------------------*/
        // Add New News
        Route::get('/news/create', 'NewsController@create')->name('news.create');
        // Store New News
        Route::post('/news', 'NewsController@store')->name('news.store');
        // View all News
        Route::get('/news', 'NewsController@index')->name('news.index');
        // View a single News
        Route::get('/news/{news}', 'NewsController@show')->name('news.show');
        // Edit a News
        Route::get('/news/{news}/edit', 'NewsController@edit')->name('news.edit');
        // Update a News
        Route::put('/news/{news}', 'NewsController@update')->name('news.update');
        // Delete a News
        Route::delete('/news/{news}', 'NewsController@destroy')->name('news.destroy');
        
        
        /*--------------------------------
        Admin Imoprtant Link Route
        --------------------------------*/
        // Route::resource('important-links', ImportantLinksController::class);  
        Route::resource('important-links', 'ImportantLinksController');


        /*--------------------------------
        Admin Gallery Route
        --------------------------------*/
        // Add New Galleries
        Route::get('/galleries/create', 'GalleryController@create')->name('galleries.create');
        // Store New Galleries
        Route::post('/galleries', 'GalleryController@store')->name('galleries.store');
        // View all Galleries
        Route::get('/galleries', 'GalleryController@index')->name('galleries.index');
        // View a single Galleries
        Route::get('/galleries/{gallery}', 'GalleryController@show')->name('galleries.show');
        // Edit a Galleries
        Route::get('/galleries/{gallery}/edit', 'GalleryController@edit')->name('galleries.edit');
        // Update a Galleries
        Route::put('/galleries/{gallery}', 'GalleryController@update')->name('galleries.update');
        // Delete a Galleries
        Route::delete('/galleries/{gallery}', 'GalleryController@destroy')->name('galleries.destroy');

        /*--------------------------------
        Dynamic Pages Route
        --------------------------------*/
        // Add New Page
        Route::get('/pages/create', 'PageController@create')->name('pages.create');
        // Store New Page
        Route::post('/pages', 'PageController@store')->name('pages.store');
        // View all Pages
        Route::get('/pages', 'PageController@index')->name('pages.index');
        // View a single Page
        Route::get('/pages/{page}', 'PageController@show')->name('pages.show');
        // Edit a Page
        Route::get('/pages/{page}/edit', 'PageController@edit')->name('pages.edit');
        // Update a Page
        Route::put('/pages/{page}', 'PageController@update')->name('pages.update');
        // Delete a Page
        Route::delete('/pages/{page}', 'PageController@destroy')->name('pages.destroy');
    });

    // Dynamic Pages User View
    Route::get('/{slug}', function (\App\Page $slug) {
        return view('frontend.pages.index', compact('slug'));
    })->name('pages');
});






