@extends('layouts.frontend.master')

@section('content')
<div class="seminar-reg-wrapper">
	<div class="seminar-container container">
		<h1 class="seminar-reg-wrapper-title text-center">
			Registration for Upcoming Seminar!
		</h1>
		<div class="row">
			<div class="col-md-8 offset-md-2 col-sm-12 col-xs-12 seminar-col">
					<div class="seminar-wrapper">
							<h3 class="text-left seminar-title">Register for Upcoming Seminar</h3>
								@if(session()->has('success'))
									<div class="alert alert-danger">
									{{ session()->get('success') }}
									</div>
								@endif
								@if ($errors->any())
									<div class="alert alert-danger">
										<strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
									</div>
								@endif
								<form method="POST" action="{{route('seminar.sendInfo')}}">
									@csrf
									<div class="form-group row">
										<label for="name" class="col-md-12 col-form-label text-md-left">{{ __('Name') }}</label>

										<div class="col-md-12">
											<input id="name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') }}" placeholder="Your Full Name" onfocus="this.placeholder=''" onblur="this.placeholder='Your Full Name'" required>

											@if ($errors->has('name'))
												<span class="invalid-feedback" role="alert">
													<strong>{{ $errors->first('name') }}</strong>
												</span>
											@endif
										</div>
									</div>

									<div class="form-group row">
										<label for="designation" class="col-md-12 col-form-label text-md-left">{{ __('Designation') }}</label>

										<div class="col-md-12">
											<input id="designation" type="text" class="form-control{{ $errors->has('designation') ? ' is-invalid' : '' }}" name="designation" value="{{ old('designation') }}" placeholder="Your Designation" onfocus="this.placeholder=''" onblur="this.placeholder='Your Designation'" required>

											@if ($errors->has('designation'))
												<span class="invalid-feedback" role="alert">
													<strong>{{ $errors->first('designation') }}</strong>
												</span>
											@endif
										</div>
									</div>

									<div class="form-group row">
											<label for="company_name" class="col-md-12 col-form-label text-md-left">{{ __('Company Name') }}</label>

											<div class="col-md-12">
												<input id="company_name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="company_name" value="{{ old('company_name') }}" placeholder="Your Company Name" onfocus="this.placeholder=''" onblur="this.placeholder='Your Company Name'" required>

												@if ($errors->has('company_name'))
													<span class="invalid-feedback" role="alert">
														<strong>{{ $errors->first('company_name') }}</strong>
													</span>
												@endif
											</div>
									</div>

									<div class="form-group">
										<label for="address">Address</label>
										<textarea class="form-control{{ $errors->has('address') ? ' is-invalid' : '' }}" id="address" name="address" rows="2" required>
											{{ old('address') }}
										</textarea>

										@if ($errors->has('address'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ $errors->first('address') }}</strong>
										</span>
										@endif
									</div>

									<div class="form-group row">
											<label for="conatact_person" class="col-md-12 col-form-label text-md-left">{{ __('Contact Person') }}</label>

											<div class="col-md-12">
												<input id="conatact_person" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="conatact_person" value="{{ old('conatact_person') }}" placeholder="Contact Person" onfocus="this.placeholder=''" onblur="this.placeholder='Contact Person'" required>

												@if ($errors->has('conatact_person'))
													<span class="invalid-feedback" role="alert">
														<strong>{{ $errors->first('conatact_person') }}</strong>
													</span>
												@endif
											</div>
									</div>

									<div class="form-row">
											<div class="form-group col-md-6">
												<label for="mobile">Mobile</label>
												<input type="text" class="form-control{{ $errors->has('mobile') ? ' is-invalid' : '' }}" name="mobile" value="{{ old('mobile') }}" id="mobile" placeholder="Mobile No." onfocus="this.placeholder=''" onblur="this.placeholder='Mobile No.'" required>

												@if ($errors->has('mobile'))
												<span class="invalid-feedback" role="alert">
													<strong>{{ $errors->first('mobile') }}</strong>
												</span>
												@endif
											</div>
											<div class="form-group col-md-6">
											  <label for="email">Email</label>
											  <input type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" id="email" name="email" value="{{ old('email') }}"  placeholder="Email Address" onfocus="this.placeholder=''" onblur="this.placeholder='Email Address'" required>

											  @if ($errors->has('email'))
											  <span class="invalid-feedback" role="alert">
												  <strong>{{ $errors->first('email') }}</strong>
											  </span>
											  @endif
											</div>
									</div>

									<div class="form-group">
										<label for="message">Message</label>
										<textarea class="form-control" id="message" name="message" rows="5">{{ old('message') }}</textarea>
										@if ($errors->has('message'))
										<span class="invalid-feedback" role="alert">
											<strong>{{ $errors->first('message') }}</strong>
										</span>
										@endif
									</div>
									<br>

									<button type="submit" class="btn btn-primary">Send</button>
								</form>
					</div>
			</div>
			{{--
			<div class="col-md-5 col-sm-12 com-xs-12 seminar-col">
				<div class="upcoming-seminar-wrapper">
						<h3 class="upcoming-seminar-list-title text-center">Upcoming Seminars</h3>
						<div class="seminar-content">
							<div class="seminar-title">
								<div class="row no-gutters">
									<div class="col-md-3 seminar-content-col">
											<h5 class="title">Title :</h5>
									</div>
									<div class="col-md-9 seminar-content-col">
										<h5 class="title-text">GRAPHIC DESIGN</h5>
									</div>
									<div class="col-md-3 seminar-content-col">
											<h5 class="topics-title">Topics :</h5>
									</div>
									<div class="col-md-9 seminar-content-col">
										<h6 class="topics-text">Web Design & Development, Carrier in Web, Outsourcing Market ...</h6>
									</div>
									<div class="col-md-4 seminar-content-col text-center">
										<h5 class="title">Date</h5>
										<p>26 October 2018</p>
									</div>
									<div class="col-md-4  seminar-content-col text-center">
										<h5 class="title">Time</h5>
										<p>4:00 PM</p>
									</div>
									<div class="col-md-4  seminar-content-col text-center">
										<h5 class="title">Instructor</h5>
										<p>Md. Sayedul Islam</p>
									</div>
								</div>
							</div>
						</div>
						<div class="seminar-content">
							<div class="seminar-title">
								<div class="row no-gutters">
									<div class="col-md-3 seminar-content-col">
											<h5 class="title">Title :</h5>
									</div>
									<div class="col-md-9 seminar-content-col">
										<h5 class="title-text">GRAPHIC DESIGN</h5>
									</div>
									<div class="col-md-3 seminar-content-col">
											<h5 class="topics-title">Topics :</h5>
									</div>
									<div class="col-md-9 seminar-content-col">
										<h6 class="topics-text">Web Design & Development, Carrier in Web, Outsourcing Market ...</h6>
									</div>
									<div class="col-md-4 seminar-content-col text-center">
										<h5 class="title">Date</h5>
										<p>26 October 2018</p>
									</div>
									<div class="col-md-4  seminar-content-col text-center">
										<h5 class="title">Time</h5>
										<p>4:00 PM</p>
									</div>
									<div class="col-md-4  seminar-content-col text-center">
										<h5 class="title">Instructor</h5>
										<p>Md. Sayedul Islam</p>
									</div>
								</div>
							</div>
						</div>
						<div class="seminar-content">
							<div class="seminar-title">
								<div class="row no-gutters">
									<div class="col-md-3 seminar-content-col">
											<h5 class="title">Title :</h5>
									</div>
									<div class="col-md-9 seminar-content-col">
										<h5 class="title-text">GRAPHIC DESIGN</h5>
									</div>
									<div class="col-md-3 seminar-content-col">
											<h5 class="topics-title">Topics :</h5>
									</div>
									<div class="col-md-9 seminar-content-col">
										<h6 class="topics-text">Web Design & Development, Carrier in Web, Outsourcing Market ...</h6>
									</div>
									<div class="col-md-4 seminar-content-col text-center">
										<h5 class="title">Date</h5>
										<p>26 October 2018</p>
									</div>
									<div class="col-md-4  seminar-content-col text-center">
										<h5 class="title">Time</h5>
										<p>4:00 PM</p>
									</div>
									<div class="col-md-4  seminar-content-col text-center">
										<h5 class="title">Instructor</h5>
										<p>Md. Sayedul Islam</p>
									</div>
								</div>
							</div>
						</div>
				</div>
			</div>
			--}}
		</div>
	</div>
</div>
@endsection
