@extends('layouts.frontend.master')

@section('content')
<div class="news-and-events">
		<div class="container">
			<h1 class="text-center news-and-events-title">NEWS & EVENTS</h1>
			<div class="news-and-events-items">
				<div class="row">
				@foreach($news as $singleNews)
				<div class="col-md-6 col-sm-12 col-xs-12 news-col">
					<div class="news-and-events-box-content d-flex">
							<img src="{{ asset('img/news/'.$singleNews->image) }}" style="width:200px; max-height:250px" class="img-fluid" alt="{{ $singleNews->title }}">
							<div class="news-and-events-description">
								<a href="news/{{$singleNews->id}}" class="service-box-clickable">
									<h3 class="news-and-events-box-content-title">{{ $singleNews->title }}</h3>
								</a>
								<p class="news-and-events-publish-info">Published in {{ $singleNews->created_at->toFormattedDateString()}} IN <a href="/news" class="news-route">News</a></p>
								<p class="news-and-events-box-content-description">{{ $singleNews->excerpt }}</p>
								<div class="readmore">
										<a href="{{route('news.show',$singleNews->slug)}}">READ MORE</a>
								</div>
							</div>
					</div>
				</div>
				@endforeach
			</div>
			</div>
		</div>
</div>
@endsection