@extends('layouts.frontend.master')

@section('content')
<div class="individual-course-details">
		<div class="container">
			<h1 class="individual-course-details-title text-center">Course Details</h1>
			<div class="row no-gutters">
				<div class="col-md-8 individual-course-col">
					<h1>{{$course->title}}</h1>
					<span class="border-title"></span>
					<div class="description">
						{!! $course->description !!}
					</div>
				</div>
				<div class="col-md-4 individual-course-col">
					<div class="individual-course-details-price-wrapper">
						<h2 class="price-text d-none">Price: <span class="price-amount">Tk. {{$course->price}}</span></b></h2>
						<div class="reg-btn-wrapper">
							<a href="{{route('seminar.register')}}" class="reg-btn">
								Register
							</a>
						</div>
						<div class="contact-wrapper">
							<h3 class="contact-text">
								Contact
							</h3>
							<p class="contact">
								Call: {{$course->contact_mobile}}
							</p>
							<p class="contact">
								Email: <a href="mailto:{{$course->contact_email}}">{{$course->contact_email}}</a>
							</p>
						</div>
					</div>
					<div class="individual-course-info-wrapper">
						<h4 class="course-shortinfo-title">Course Information</h4>
						<span class="border-title"></span>
						<p><span class="course-info-subtitle"><i class="far fa-calendar-check"></i> Date :</span> {{$courseEvent->start_date->format('d M')}} - {{$courseEvent->end_date->format('d M Y')}}</p>
						<p><span class="course-info-subtitle"><i class="fas fa-list-ul"></i> No. of Classes :</span> {{$courseEvent->total_no_of_class}}</p>
						<p><span class="course-info-subtitle"><i class="far fa-clock"></i> Total Hours :</span> {{$courseEvent->total_hours}}</p>
						<p><span class="course-info-subtitle"><i class="far fa-calendar-times"></i> Last Date of Registration :</span> {{$courseEvent->last_date_of_reg->format('d M Y')}}</p>
						<p><span class="course-info-subtitle"><i class="fas fa-list-ul"></i> Instructor :</span> {{$courseEvent->courseTrainer->name}}</p>
						<p><span class="course-info-subtitle"><i class="far fa-calendar-alt"></i> Class Schedule :</span></p>
						<div class="class-schedule">
							@foreach($courseEvent->schedules as $courseSchedule)
							<p>{{$courseSchedule->day}} - {{$courseSchedule->start_time->format('h:m A')}} - {{$courseSchedule->end_time->format('h:m A')}}</p>
							@endforeach
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection