@extends('layouts.frontend.master')

@section('content')
<div class="contact-location-wrapper">
	<div class="contact-container container">
		<h1 class="contacts-title text-center text-white">
			Contact Us
		</h1>
		<div class="row">
			<div class="col-md-8 col-sm-12 col-xs-12 contacts-col">
					<div class="contact-wrapper">
							<h2 class="text-left address-title">Contact with Us</h2>
								@if(session()->has('success'))
									<div class="alert alert-danger">
									{{ session()->get('success') }}
									</div>
								@endif
								@if ($errors->any())
									<div class="alert alert-danger">
										<ul>
											@foreach ($errors->all() as $error)
												<li>{{ $error }}</li>
											@endforeach
										</ul>
									</div>
								@endif
								<form method="POST" action="/contact-us">
									@csrf
									<div class="form-row">
										<div class="col">
											<label for="to">To</label>
											<input type="text" class="form-control" name="to" readonly value="info@sholoyana.org">
										</div>
									</div>
									<br>

									<div class="form-row">
										<div class="col">
											<label for="email">From</label>
											<input type="text" class="form-control" id="email" name="email" placeholder="Email Address" onfocus="this.placeholder=''" onblur="this.placeholder='Email Address'" required>
										</div>
									</div>
									<br>
									<div class="form-row">
										<div class="col">
											<label for="subject">Subject</label>
											<input type="text" class="form-control" name="subject" placeholder="Subject" onfocus="this.placeholder=''" onblur="this.placeholder='Subject'" required>
										</div>
									</div>
									<br>

									<div class="form-group">
										<label for="message">Message</label>
										<textarea class="form-control" id="message" name="message" rows="5"></textarea>
									</div>
									<br>
									<button type="submit" class="btn btn-primary">Send</button>
								</form>
						</div>
			</div>
			<div class="col-md-4 col-sm-12 com-xs-12 contacts-col">
					<div class="contact-address">
							<h5>Address:</h5>
							<ul>
								<li><i class="far fa-building"></i> {{config('app.name')}}</li>
								<li class="d-flex">
									<i class="fas fa-home"></i>
    								
    								<span>
									 Address : Char Bara Baria, Chitalmari, Begerhat, Bangladesh
    								</span>
							</li>
							<li><i class="fas fa-phone-square"></i>+88 01741423506</li>
							<li><i class="far fa-envelope"></i> info@sholoyana.org</li>
							<li><i class="fas fa-globe-asia"></i>http://sholoyana.org</li>
							</ul>

					</div>
					&nbsp;
					<!--<div class="contact-address">-->
					<!--		<h5>Gazipur Office:</h5>-->
					<!--		<ul>-->
					<!--			<li><i class="far fa-building"></i> {{config('app.name')}}</li>-->
					<!--			<li class="d-flex">-->
					<!--				<i class="fas fa-home"></i>-->
    								
    	<!--							<span>-->
					<!--				     House No. 68, Titarkul Road, Gazipur Sadar, Gazipur-1700.-->
    	<!--							</span>-->
					<!--		</li>-->
					<!--		<li><i class="fas fa-phone-square"></i>+8801635755902</li>-->
					<!--		<li><i class="far fa-envelope"></i>info@akd.com.bd</li>-->
					<!--		<li><i class="fas fa-globe-asia"></i>www.akd.com.bd</li>-->
					<!--		</ul>-->

					<!--</div>-->
							
					
			</div>
		</div>
		<!--<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d29187.407137912018!2d90.391928!3d23.874512000000003!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x7ab877cffc453c5a!2sUttara%20InfoTech!5e0!3m2!1sen!2sus!4v1622695626526!5m2!1sen!2sus" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>-->
		

        <!--<iframe style="width:100%; height:300px," src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1824.2121069593145!2d90.40064175797554!3d23.87457154883602!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x7d48f202db02df99!2sBhuiyan%20Enterprise!5e0!3m2!1sen!2sbd!4v1616562154132!5m2!1sen!2sbd"  allowfullscreen="" loading="lazy"></iframe>-->

	</div>
</div>
@endsection