@extends('layouts.admin.master')

@section('title', 'View All SubChildCategories')

@section('subTitle', 'All SubChildCategories Information is Available Here.')

@section('button')
	<a href="{{ route('admin.subcategories.create') }}" class="btn btn-info">Add New SubChildCategory</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <!-- <div class="card-header d-flex justify-content-between"><span>{{ __('View all SubChildCategories') }}</span> <span><a href="" class="btn btn-success">Add New Category</a></span></div> -->

                <div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif
						<table class="table table-bordered table-hover table-responsive">
											<thead class="thead-default">
												<tr>
													<th>#</th>
													<th>Name</th>
													<th>Category Name</th>
													<th>SubCategory Name</th>
													<th>Slug</th>
													<th>Order</th>
													<th>Added By</th>
													<th>Updated By</th>
													<th>Actions</th>
												</tr>
											</thead>
											<tbody>
											@if(count($childcategories))
												@foreach($childcategories as $childcategory)
												<tr>
													<th scope="row">{{ $childcategory->id }}</th>
													<td>{{ $childcategory->name }}</td>
													<td>{{ $childcategory->category ? $childcategory->category->name : 'N/A'}}</td>
													<td>{{ $childcategory->subcategory ? $childcategory->subcategory->name : 'N/A'}}</td>
													<td>{{ $childcategory->slug }}</td>
													<td>{{ $childcategory->order }}</td>
													<td>{{ $childcategory->addedBy ? $childcategory->addedBy->name : 'N/A' }}</td>
													<td>{{ $childcategory->editedBy ? $childcategory->editedBy->name : 'N/A' }}</td>
													<td class="text-center d-flex justify-content-center">

														<a href="{{ route('admin.subcategories.edit',$childcategory->slug) }}" class="btn btn-warning">Edit</a>
														<form action="{{ route('admin.subcategories.destroy',$childcategory->slug) }}" method="post">
															@csrf
															<input type="hidden" name="_method" value="DELETE">
															<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
														</form>
													</td>
												</tr>
												@endforeach
											@endif
											</tbody>
										</table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
