@extends('layouts.admin.master')

@section('title', 'Add New Product')

@section('subTitle', 'Add new product as mush you need.')

@section('button')
	<a href="{{ route('admin.products') }}" class="btn btn-success">View All Products</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                        @if ($message = Session::get('success'))
						<div class="alert bg-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif
                    <form method="POST" action="{{ route('admin.products.store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group row">
                            <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('Name') }}</label>

                            <div class="col-md-8">
                                <input id="name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name') }}" required autofocus>

                                @if ($errors->has('name'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="category_id" class="col-md-4 col-form-label text-md-right">{{ __('Parent Category') }}</label>

                            <div class="col-md-8">
                                <select id="category_id" class="form-control{{ $errors->has('category_id') ? ' is-invalid' : '' }}" name="category_id" required>
                                    @if(count($categories))
                                    @foreach($categories as $key => $category)
                                    <option value="{{$category->id}}" {{$key==0 ? 'selected' : ''}}>{{$category->name}}</option>
                                    @endforeach
                                    @endif
                                </select>

                                @if ($errors->has('category_id'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('category_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="subcategory_id" class="col-md-4 col-form-label text-md-right">{{ __('Parent SubCategory') }}</label>

                            <div class="col-md-8">
                                <select id="subcategory_id" class="form-control{{ $errors->has('subcategory_id') ? ' is-invalid' : '' }}" name="subcategory_id">
                                    <option value="0" selected>N/A</option>
                                    @if(count($subcategories))
                                    @foreach($subcategories as $key => $subcategory)
                                    <option value="{{$subcategory->id}}">{{$subcategory->name}}</option>
                                    @endforeach
                                    @endif
                                </select>

                                @if ($errors->has('subcategory_id'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('subcategory_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="childcategory_id" class="col-md-4 col-form-label text-md-right">{{ __('Parent SubChildCategory') }}</label>

                            <div class="col-md-8">
                                <select id="childcategory_id" class="form-control{{ $errors->has('childcategory_id') ? ' is-invalid' : '' }}" name="childcategory_id">
                                    <option value="0" selected>N/A</option>
                                    @if(count($subchildcategories))
                                    @foreach($subchildcategories as $key => $childcategory)
                                    <option value="{{$childcategory->id}}">{{$childcategory->name}}</option>
                                    @endforeach
                                    @endif
                                </select>

                                @if ($errors->has('childcategory_id'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('childcategory_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="season" class="col-md-4 col-form-label text-md-right">{{ __('Season') }}</label>

                            <div class="col-md-8">
                                <select id="season" class="form-control{{ $errors->has('season') ? ' is-invalid' : '' }}" name="season" required>
                                    <option value="summer">Summer</option>
                                    <option value="autumn">Autumn</option>
                                    <option value="winter">Winter</option>
                                </select>

                                @if ($errors->has('season'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('season') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="brand" class="col-md-4 col-form-label text-md-right">{{ __('Brand Name') }}</label>

                            <div class="col-md-8">
                                <select id="brand" class="form-control{{ $errors->has('brand') ? ' is-invalid' : '' }}" name="brand" required>
                                    <option value="0">N/A</option>
                                    @if(count($brands))
                                    @foreach ($brands as $brand)
                                    <option value="{{ $brand->id }}" {{ old('brand')== $brand->id ? 'selected' : '' }}>{{ $brand->name }}</option>
                                    @endforeach
                                    @endif
                                </select>

                                @if ($errors->has('brand'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('brand') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="hassize" class="col-md-4 col-form-label text-md-right">{{ __('Has Size ?') }}</label>

                            <div class="col-md-8">
                                <select id="hassize" class="form-control{{ $errors->has('hassize') ? ' is-invalid' : '' }}" name="hassize" required>
                                    <option value="0">N/A</option>
                                    <option value="1">Yes</option>
                                </select>

                                @if ($errors->has('hassize'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('hassize') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="sizes" style="line-height: 14.5px;" class="col-md-4 col-form-label text-md-right">{!! __('Sizes <br><small>Separated by Commas</small>') !!}</label>

                            <div class="col-md-8">
                                <input id="sizes" type="text" class="form-control{{ $errors->has('sizes') ? ' is-invalid' : '' }}" name="sizes" value="{{ old('sizes') }}" autofocus>

                                @if ($errors->has('sizes'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('sizes') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="hascolor" class="col-md-4 col-form-label text-md-right">{{ __('Has Color ?') }}</label>

                            <div class="col-md-8">
                                <select id="hascolor" class="form-control{{ $errors->has('hascolor') ? ' is-invalid' : '' }}" name="hascolor" required>
                                    <option value="0">N/A</option>
                                    <option value="1">Yes</option>
                                </select>

                                @if ($errors->has('hascolor'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('hascolor') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="colors" style="line-height: 14.5px;" class="col-md-4 col-form-label text-md-right">{!! __('Colors <br><small>Separated by Commas</small>') !!}</label>

                            <div class="col-md-8">
                                <input id="colors" type="text" class="form-control{{ $errors->has('colors') ? ' is-invalid' : '' }}" name="colors" value="{{ old('colors') }}">

                                @if ($errors->has('colors'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('colors') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="purchase_price" class="col-md-4 col-form-label text-md-right">{{ __('Purchase Price') }}</label>

                            <div class="col-md-8">
                                <input id="purchase_price" type="number" class="form-control{{ $errors->has('purchase_price') ? ' is-invalid' : '' }}" oninput="calculateDiscount()" name="purchase_price"  min="0" value="{{ old('purchase_price') ? old('purchase_price') : '0'}}" step="0.01" required autofocus>

                                @if ($errors->has('purchase_price'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('purchase_price') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="sale_price" class="col-md-4 col-form-label text-md-right">{{ __('Sale Price') }}</label>

                            <div class="col-md-8">
                                <input id="sale_price" type="number" min="0" class="form-control{{ $errors->has('sale_price') ? ' is-invalid' : '' }}" name="sale_price" oninput="calculateDiscount()" value="{{ old('sale_price') ? old('sale_price') : '0' }}" step="0.01" required autofocus>

                                @if ($errors->has('sale_price'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('sale_price') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                            <label for="discount_amount" class="col-md-4 col-form-label text-md-right">{{ __('Discount Amount') }}</label>

                            <div class="col-md-8">
                                <input id="discount_amount" type="number" min="0" class="form-control{{ $errors->has('discount_amount') ? ' is-invalid' : '' }}" name="discount_amount" oninput="calculateDiscount()" value="{{ old('discount_amount') ? old('discount_amount') : '0' }}" step="0.01" required autofocus>

                                @if ($errors->has('discount_amount'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('discount_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="final_price" class="col-md-4 col-form-label text-md-right">{{ __('Final Price') }}</label>

                            <div class="col-md-8">
                                <input id="final_price" type="number" min="0" class="form-control{{ $errors->has('final_price') ? ' is-invalid' : '' }}" name="final_price" value="{{ old('final_price') }}" step="0.01" required readonly autofocus>

                                @if ($errors->has('final_price'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('final_price') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="profit_amount" class="col-md-4 col-form-label text-md-right">{{ __('Profit Amount') }}</label>

                            <div class="col-md-8">
                                <input id="profit_amount" type="number" class="form-control{{ $errors->has('profit_amount') ? ' is-invalid' : '' }}" name="profit_amount" value="{{ old('profit_amount') ? old('profit_amount') : 0 }}" step="0.01" required readonly autofocus>

                                @if ($errors->has('profit_amount'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('profit_amount') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="description" class="col-md-4 col-form-label text-md-right">{{ __('Description') }}</label>

                            <div class="col-md-8">
                                <textarea class="form-control{{ $errors->has('description') ? ' is-invalid' : '' }}" name="description" id="description" rows="3">{{ old('description') }}</textarea>

                                @if ($errors->has('description'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="featured_image" style="line-height: 14.5px;" class="col-md-4 col-form-label text-md-right">{!! __('Featured Image <br><small>Max Size:1.5MB, Dimensions: 360x319</small>') !!}</label>

                            <div class="col-md-8">
                                <input type="file" class="form-control-file{{ $errors->has('featured_image') ? ' is-invalid' : '' }}" id="featured_image" name="featured_image" value="{{ old('featured_image') ? old('featured_image') : '' }}">

                                @if ($errors->has('featured_image'))
                                    <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                        <strong>{{ $errors->first('featured_image') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="other_images" style="line-height: 14.5px;" class="col-md-4 col-form-label text-md-right">{!! __('Product Images <br><small>Max: 4 Images, Max Size:1.5MB, Dimensions: 1024x910</small>') !!}</label>
                            <div class="col-md-8">
                                <input type="file" class="form-control-file{{ $errors->has('other_images.*') ? ' is-invalid' : '' }}" id="other_images" name="other_images[]" value="{{ old('other_images') ? old('other_images') : '' }}" multiple>
                                @if ($errors->has('other_images.all'))
                                    <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                        <strong>{{ $errors->first('other_images.all') }}</strong>
                                    </span>
                                @endif
                                @if($errors->has('other_images.*'))
                                    @foreach($errors->get('other_images.*') as $message)
                                    <span class="invalid-feedback-file" role="alert" style="margin-top: .25rem; font-size: .875rem; color: #dc3545;">
                                        <strong>{{ $message[0] }} </strong>
                                    </span>
                                <br>
                                    @endforeach
                                @endif
                            </div>
                        </div>


                        <div class="form-group row">
                                <label for="order" class="col-md-4 col-form-label text-md-right">{{ __('Order') }}</label>

                                <div class="col-md-8">
                                    <input id="order" type="number" class="form-control{{ $errors->has('order') ? ' is-invalid' : '' }}" name="order" value="{{ old('order') ? old('order') : 1 }}" required>

                                    @if ($errors->has('order'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $errors->first('order') }}</strong>
                                        </span>
                                    @endif
                                </div>
                        </div>

                        <div class="form-group row mb-0">
                        <div class="col-md-4"></div>
                            <div class="col-md-6">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Add') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>

    function calculateDiscount(){
        var salePrice = document.querySelector('#sale_price').value;
        var salePrice = parseFloat(salePrice) ?  parseFloat(salePrice) : 0;


        var discountPrice = document.querySelector('#discount_amount').value;
        var discountPrice = parseFloat(discountPrice) ?  parseFloat(discountPrice) : 0;

        var purchasePrice = document.querySelector('#purchase_price').value;
        var purchasePrice = parseFloat(purchasePrice) ?  parseFloat(purchasePrice) : 0;


        var finalPrice = document.querySelector('#final_price');
        var profitAmount = document.querySelector('#profit_amount');
        var calcFinal = salePrice - (salePrice * discountPrice/100);
        finalPrice.value = parseFloat(Math.round(calcFinal * 100) / 100).toFixed(2);
         var calcProfit = parseFloat(finalPrice.value) - purchasePrice;
         profitAmount.value = parseFloat(Math.round(calcProfit * 100) / 100).toFixed(2);
    }
    window.onload = function() {

        try {
            calculateDiscount();
        } catch (error) {

        }
    };

</script>
@endsection
