@extends('layouts.admin.master')

@section('title', 'Edit a Page')

@section('subTitle', 'Edit a page as mush you need.')

@section('button')
	<a href="{{ route('admin.pages.index') }}" class="btn btn-success">View All Pages</a>
@endsection



@section('content')
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif

						@if (count($errors) > 0)
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								@foreach ($errors->all() as $error)
								<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
						@endif
						<form action="{{route('admin.pages.update',$page->slug)}}" method="POST" enctype="multipart/form-data">
							@csrf
							<input type="hidden" name="_method" value="PUT">
							<div class="form-group">
									<label for="title">Page Title</label>
									<input type="text" class="form-control" id="title" name="title" value="{{ old('title') ? old('title') : $page->title}}" required>
								</div>
							<div class="form-group">
								<label for="subtitle">Page SubTitle</label>
								<input type="text" class="form-control" id="subtitle" name="subtitle" value="{{ old('subtitle') ? old('subtitle') : $page->subtitle}}">
							</div>
							<div class="form-group">
								<label for="image">Page feature Photo (Leave empty if No image change Needed)</label>
								<div><img src="/img/pages/{{$page->image}}" alt=""  width="200" height="100"></div>
								<br>
								<input type="file" class="form-control-file" id="image" name="image">
							</div>
							<div class="form-group">
									<label for="description">Description</label>
									<textarea class="form-control summernote" id="description" name="description" rows="4">{{ old('description') ? old('description') : $page->description}}</textarea>
							</div>
							<div class="form-group">
								<label for="slug" style="font-weight:700;">Slug <span style="color:#dc3545;">(Any Changes will broke the page)</span></label>
								<input type="text" class="form-control is-invalid" id="slug" name="slug" value="{{ old('slug') ? old('slug') : $page->slug}}">
    						      <div class="invalid-feedback">
                                    URL friendly slug. like: laravel-5-framework. Only alphanumeric characters and hyphen is applicable.
                                  </div>
							</div>
							<div class="form-group">
								<label for="order">Order</label>
								<input type="text" class="form-control" id="order" name="order" value="{{ old('order') ? old('order') : $page->order}}" required>
							</div>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

@endsection