@extends('layouts.admin.master')

@section('title', 'Edit a News')

@section('subTitle', 'Edit a news as mush you need.')

@section('button')
	<a href="{{ route('admin.news.index') }}" class="btn btn-success">View All News</a>
@endsection



@section('content')
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif

						@if (count($errors) > 0)
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								@foreach ($errors->all() as $error)
								<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
						@endif
						<form action="{{route('admin.news.update',$news->slug)}}" method="POST" enctype="multipart/form-data">
							@csrf
							<input type="hidden" name="_method" value="PUT">
							<div class="form-group">
								<label for="title">Title</label>
								<input type="text" class="form-control" id="title" name="title" value="{{ old('name') ? old('name') : $news->title}}" required>
							</div>
							<div class="form-group">
								<label for="image">Photo (Leave empty if No image change Needed)</label>
								<div><img src="/img/news/{{$news->image}}" alt=""  width="200" height="100"></div>
								<br>
								<input type="file" class="form-control-file" id="image" name="image">
							</div>
							<div class="form-group">
								<label for="shortdescription">Short Description (Maximun 160 Characters)</label>
								<textarea class="form-control" id="shortdescription" maxlength="160" name="shortdescription"  value="" rows="2"  required>{{$news->excerpt}}</textarea>
							</div>
							<div class="form-group">
								<label for="longdescription">Long Description (Maximun 2000 Characters)</label>
								<textarea class="form-control summernote" id="longdescription" maxlength="2000" name="longdescription"  rows="6" cols="80"  required>{{$news->description}}</textarea>
							</div>
							<div class="form-group">
								<label for="order">Position</label>
								<input type="text" class="form-control" id="order" name="order" value="{{ old('order') ? old('order') : $news->order}}" required>
							</div>
							<br>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

@endsection