@extends('layouts.admin.master')

@section('title', 'Add New News')

@section('subTitle', 'Add new news as mush you need.')

@section('button')
	<a href="{{ route('admin.news.index') }}" class="btn btn-success">View All News</a>
@endsection



@section('content')
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif

						@if (count($errors) > 0)
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								@foreach ($errors->all() as $error)
								<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
						@endif
						<form action="{{route('admin.news.store')}}" method="POST" enctype="multipart/form-data">
							@csrf
							<div class="form-group">
								<label for="title">Title</label>
								<input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
							</div>
							<div class="form-group">
								<label for="image">News Photo (Max Length: 500KB)</label>
								<input type="file" class="form-control-file" id="image" name="image" required>
							</div>
							<div class="form-group">
								<label for="shortdescription">Short Description (Maximun 160 Characters)</label>
								<textarea class="form-control summernote" id="shortdescription" maxlength="160" name="shortdescription"  value="" rows="2"  required>{{ old('shortdescription') }}</textarea>
							</div>
							<div class="form-group">
								<label for="longdescription">Long Description (Maximun 2000 Characters)</label>
								<textarea class="form-control" id="longdescription" maxlength="2000" name="longdescription"  rows="6" cols="80"  required>{{ old('longdescription') }}</textarea>
							</div>

							<div class="form-group" style="display:none">
								<label for="order" class="col-md-12 col-form-label text-md-left">{{ __('Position') }}</label>
								<input id="order" type="number" class="form-control{{ $errors->has('order') ? ' is-invalid' : '' }}" name="order" value="{{ old('order') ? old('order') : 1 }}" required>
							</div>

							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

@endsection