@extends('layouts.admin.master')

@section('title', 'Add New Important Link')

@section('subTitle', 'Add new link as you need.')

@section('button')
	<a href="{{ route('admin.important-links.index') }}" class="btn btn-success">View All Important Links</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @if ($message = Session::get('success'))
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                        <strong>{{ $message }}</strong>
                    </div>
                    @endif

                    @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <strong>Whoops!</strong> There were some problems with your input. Please Check all fields.
                    </div>
                    @endif
                    <form method="POST" action="{{ route('admin.important-links.store') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="form-group">
                            <label for="title" class="col-md-12 col-form-label">{{ __('Title') }}</label>

                            <div class="col-md-12">
                                <input id="title" type="text" class="form-control{{ $errors->has('title') ? ' is-invalid' : '' }}" name="title" value="{{ old('title') }}" placeholder="Enter Title" required>

                                @if ($errors->has('title'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                         <div class="form-group">
                            <label for="url" class="col-md-12 col-form-label">{{ __('Url') }}</label>

                            <div class="col-md-12">
                                <input id="url" type="text" class="form-control{{ $errors->has('url') ? ' is-invalid' : '' }}" name="url" value="{{ old('url') }}" placeholder="example.com" required>

                                @if ($errors->has('url'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('url') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                         <div class="form-group">
                            <label for="priority" class="col-md-12 col-form-label">{{ __('Position') }}</label>

                            <div class="col-md-12">
                                <input id="priority" type="number" class="form-control{{ $errors->has('priority') ? ' is-invalid' : '' }}" name="priority" value="{{ old('priority') }}" placeholder="example: 1 or 2 etc" required>

                                @if ($errors->has('priority'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('priority') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        

                        <!--<div class="form-group">-->
                        <!--    <label for="description" class="col-md-12 col-form-label">{{ __('Description') }} (Optional)</label>-->

                        <!--    <div class="col-md-12">-->
                        <!--        <textarea class="form-control summernote {{ $errors->has('description') ? ' is-invalid' : '' }}" name="description" id="description" rows="3">{{ old('description') }}</textarea>-->

                        <!--        @if ($errors->has('description'))-->
                        <!--            <span class="invalid-feedback" role="alert">-->
                        <!--                <strong>{{ $errors->first('description') }}</strong>-->
                        <!--            </span>-->
                        <!--        @endif-->
                        <!--    </div>-->
                        <!--</div>-->

                        

                        <div class="form-group mb-0">
                            <div class="col-md-12"></div>
                                <div class="col-md-6">
                                    <button type="submit" class="btn btn-primary">
                                        {{ __('Add Link') }}
                                    </button>
                                </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
