@extends('layouts.admin.master')

@section('title', 'Add New Image to Gallery')

@section('subTitle', 'Add new images as mush you need.')

@section('button')
	<a href="{{ route('admin.galleries.index') }}" class="btn btn-success">View All Galleries</a>
@endsection


@section('content')
<div class="row gutters">
	<div class="col-sm-12">
		<!-- Row start -->
		<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
				<div class="card">
					<div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif

						@if (count($errors) > 0)
						<div class="alert alert-danger">
							<strong>Whoops!</strong> There were some problems with your input.
							<ul>
								@foreach ($errors->all() as $error)
								<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
						@endif
						<form action="{{route('admin.galleries.store')}}" method="POST" enctype="multipart/form-data">
							@csrf
							<div class="form-group">
								<label for="title">Image Title</label>
								<input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
							</div>
							<div class="form-group">
									<label for="excerpt">Image Caption</label>
									<textarea class="form-control" id="excerpt" name="excerpt" rows="2" required>{{ old('excerpt')}}</textarea>
							</div>
							<div class="form-group">
									<label for="type">Image Type </label>
									<select class="form-control" id="type" name="type" required>
										<option value="gallery" {{ (old("type") == 'gallery' ? "selected":"") }}>Gallery</option>
										<option value="testimonials" {{ (old("type") == 'testimonials' ? "selected":"") }}>Testimonial</option>
										<option value="affiliated" {{ (old("type") == 'affiliated' ? "selected":"") }}>Affiliated</option>
									</select>
							</div>
							<div class="form-group">
								<label for="image">Image (Max Length: 500KB)</label>
								<input type="file" class="form-control-file" id="image" name="image" required>
							</div>
							<div class="form-group" style="display:none;">
								<label for="order">Position</label>
								<input type="number" class="form-control" id="order" name="order" value="{{ old('order') ? old('order') : '1' }}" required>
							</div>
							<div class="form-group" style="display:none;">
									<label for="slug" class="col-md-12 col-form-label text-danger font-weight-bold">{{ __('URL Optional') }} <span class="text-danger">
											(Only alphanumeric characters and hyphen is applicable.)
										</span></label>

									<div class="col-md-12">
										<input id="slug" type="text" class="form-control is-invalid" name="slug" value="{{ old('slug') }}">

										@if ($errors->has('slug'))
											<span class="invalid-feedback" role="alert">
												<strong>{{ $errors->first('slug') }}</strong>
											</span>
										@endif
									</div>
							</div>
							<button type="submit" class="btn btn-primary">Submit</button>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Row end -->
	</div>
</div>

@endsection