@extends('layouts.admin.master')

@section('title', 'View All Courses')

@section('subTitle', 'All Course Trainers Information is Available Here.')

@section('button')
	<a href="{{ route('admin.coursetrainers.create') }}" class="btn btn-success">Add New Course Trainer</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
					@if ($message = Session::get('success'))
					<div class="alert alert-success alert-block">
						<button type="button" class="close" data-dismiss="alert">×</button>
						<strong>{{ $message }}</strong>
					</div>
					@endif
					<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead class="thead-default">
								<tr>
									<th>#</th>
									<th>Name</th>
									<th class="d-none">Mobile</th>
									<th class="d-none">Email</th>
									<th class="d-none">Photo</th>
									<th>Updated By</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
								@if(count($courseTrainers))
									@foreach($courseTrainers as $courseTrainer)
									<tr>
										<th scope="row">{{ $courseTrainer->id }}</th>
										<td>{{ $courseTrainer->name }}</td>
										<td class="d-none">{{ $courseTrainer->mobile}}</td>
										<td class="d-none">{{ $courseTrainer->email}}</td>
										<td class="d-none"><img src="{{ asset('img/courses/trainer/'.$courseTrainer->photo) }}" alt="{{ $courseTrainer->name }}" width="128" heigt="128"></td>
										<td>{{ $courseTrainer->editedBy ? $courseTrainer->editedBy->name : 'N/A' }}</td>
										<td class="text-center d-flex justify-content-center">
											<a href="{{ route('admin.coursetrainers.edit',$courseTrainer->id) }}" class="btn btn-warning">Edit</a>
											<form action="{{ route('admin.coursetrainers.destroy',$courseTrainer->id) }}" method="post">
												@csrf
												<input type="hidden" name="_method" value="DELETE">
												<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
											</form>
										</td>
									</tr>
									@endforeach
								@endif
							</tbody>
						</table>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
