@extends('layouts.admin.master')

@section('title', 'View All Courses')

@section('subTitle', 'All Courses Information is Available Here.')

@section('button')
	<a href="{{ route('admin.courses.create') }}" class="btn btn-success">Add New Course</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
					@if ($message = Session::get('success'))
					<div class="alert alert-success alert-block">
						<button type="button" class="close" data-dismiss="alert">×</button>
						<strong>{{ $message }}</strong>
					</div>
					@endif
					<div class="table-responsive">
						<table class="table table-striped table-hover">
							<thead class="thead-default">
								<tr>
									<th>#</th>
									<th>Title</th>
									<th>Price</th>
									<th>Image</th>
									<th>Short Description</th>
									<th>Updated By</th>
									<th>Actions</th>
								</tr>
							</thead>
							<tbody>
								@if(count($courses))
									@foreach($courses as $course)
									<tr>
										<th scope="row">{{ $course->id }}</th>
										<td>{{ $course->title }}</td>
										<td>{{ $course->price}}</td>
										<td><img src="{{ asset('img/courses/feature/'.$course->image) }}" alt="{{ $course->title }}" width="128" heigt="128"></td>
										<td>{{ $course->excerpt}}</td>
										<td>{{ $course->editedBy ? $course->editedBy->name : 'N/A' }}</td>
										<td class="text-center d-flex justify-content-center">
											<a href="{{ route('courses.show',$course->slug) }}" class="btn btn-success">View</a>
											<a href="{{ route('admin.courses.edit',$course->slug) }}" class="btn btn-warning">Edit</a>
											<form action="{{ route('admin.courses.destroy',$course->slug) }}" method="post">
												@csrf
												<input type="hidden" name="_method" value="DELETE">
												<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
											</form>
										</td>
									</tr>
									@endforeach
								@endif
							</tbody>
						</table>
					</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
