@extends('layouts.admin.master')

@section('title', 'View All Course Events')

@section('subTitle', 'All Course Events Information is Available Here.')

@section('button')
	<a href="{{ route('admin.courseEvents.create') }}" class="btn btn-success">Add New Course Event</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">

                <div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif
						<div class="table-responsive">
							<table class="table table-bordered table-hover">
												<thead class="thead-default">
													<tr>
														<th>#</th>
														<th>Title</th>
														<th>Price</th>
														<th>Start Date</th>
														<th>End Date</th>
														<th>Last Date of Reg.</th>
														<th>Instructor</th>
														<th>Updated By</th>
														<th>Actions</th>
													</tr>
												</thead>
												<tbody>
												@if(count($courseEvents))
													@foreach($courseEvents as $courseEvent)
													<tr>
														<th scope="row">{{ $courseEvent->id }}</th>
														<td>{{ $courseEvent->course->title }}</td>
														<td>{{ $courseEvent->course->price }}</td>
														<td>{{ $courseEvent->start_date->format('d M Y')}}</td>
														<td>{{ $courseEvent->end_date->format('d M Y')}}</td>
														<td>{{ $courseEvent->last_date_of_reg->format('d M Y')}}</td>
														<td>{{ $courseEvent->courseTrainer->name}}</td>
														<td>{{ $courseEvent->editedBy ? $courseEvent->editedBy->name : 'N/A' }}</td>
														<td class="text-center d-flex justify-content-center">
															<a href="{{ route('courses.show',$courseEvent->id) }}" class="btn btn-success">View</a>
															<a href="{{ route('admin.courseEvents.edit',$courseEvent->id) }}" class="btn btn-warning">Edit</a>
															<form action="{{ route('admin.courseEvents.destroy',$courseEvent->id) }}" method="post">
																@csrf
																<input type="hidden" name="_method" value="DELETE">
																<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
															</form>
														</td>
													</tr>
													@endforeach
												@endif
												</tbody>
							</table>
						</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
