@extends('layouts.admin.master')

@section('title', 'View All Categories')

@section('subTitle', 'All Categories Information is Available Here.')

@section('button')
	<a href="{{ route('admin.categories.create') }}" class="btn btn-success">Add New Category</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <!-- <div class="card-header d-flex justify-content-between"><span>{{ __('View all Categories') }}</span> <span><a href="" class="btn btn-success">Add New Category</a></span></div> -->

                <div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif
						<table class="table table-bordered table-hover table-responsive">
											<thead class="thead-default">
												<tr>
													<th>#</th>
													<th>Name</th>
													<th>Has SubCategory</th>
													<th>Slug</th>
													<th>Order</th>
													<th>Added By</th>
													<th>Updated By</th>
													<th>Actions</th>
												</tr>
											</thead>
											<tbody>
											@if(count($categories))
												@foreach($categories as $category)
												<tr>
													<th scope="row">{{ $category->id }}</th>
													<td>{{ $category->name }}</td>
													<td>{{ $category->hassubcategory ? 'Yes' : 'No'}}</td>
													<td>{{ $category->slug }}</td>
													<td>{{ $category->order }}</td>
													<td>{{ $category->addedBy ? $category->addedBy->name : 'N/A' }}</td>
													<td>{{ $category->editedBy ? $category->editedBy->name : 'N/A' }}</td>
													<td class="text-center d-flex justify-content-center">

														<a href="{{ route('admin.categories.edit',$category->slug) }}" class="btn btn-warning">Edit</a>
														<form action="{{ route('admin.categories.destroy',$category->slug) }}" method="post">
															@csrf
															<input type="hidden" name="_method" value="DELETE">
															<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
														</form>
													</td>
												</tr>
												@endforeach
											@endif
											</tbody>
										</table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
