@extends('layouts.admin.master')

@section('title', 'View All Brands')

@section('subTitle', 'All Brands Information is Available Here.')

@section('button')
	<a href="{{ route('admin.brands.create') }}" class="btn btn-success">Add New Brand</a>
@endsection



@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
						@if ($message = Session::get('success'))
						<div class="alert alert-success alert-block">
							<button type="button" class="close" data-dismiss="alert">×</button>
							<strong>{{ $message }}</strong>
						</div>
						@endif
						<table class="table table-bordered table-hover table-responsive">
											<thead class="thead-default">
												<tr>
													<th>#</th>
													<th>Name</th>
													<th>Products Count</th>
													<th>Order</th>
													<th>Added By</th>
													<th>Updated By</th>
													<th>Actions</th>
												</tr>
											</thead>
											<tbody>
											@if(count($brands))
												@foreach($brands as $brand)
												<tr>
													<th scope="row">{{ $brand->id }}</th>
													<td>{{ $brand->name }}</td>
													<td>{{ $brand->products_count }}</td>
													<td>{{ $brand->order }}</td>
													<td>{{ $brand->addedBy ? $brand->addedBy->name : 'N/A' }}</td>
													<td>{{ $brand->editedBy ? $brand->editedBy->name : 'N/A' }}</td>
													<td class="text-center d-flex justify-content-center">

														<a href="{{ route('admin.brands.edit',$brand->slug) }}" class="btn btn-warning">Edit</a>
														<form action="{{ route('admin.brands.destroy',$brand->slug) }}" method="post">
															@csrf
															<input type="hidden" name="_method" value="DELETE">
															<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this item?');">DELETE</button>
														</form>
													</td>
												</tr>
												@endforeach
											@endif
											</tbody>
										</table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
