<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'mobile', 'gender', 'date_of_birth'
    ];

    protected $guarded = array('id', 'role');

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    // each user might have many course
    public function addedCourses()
    {
        return $this->hasMany(Course::class,'addedby_id');
    }
    public function editedCourses()
    {
        return $this->hasMany(Course::class,'editedby_id');
    }


}
