<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SubChildCategory extends Model
{

    protected $guarded = [];

    //each childcategory might have one parent category
    public function category() {
        return $this->belongsTo('App\Category', 'category_id');
    }

    //each childcategory might have one parent category
    public function subcategory() {
        return $this->belongsTo('App\SubCategory', 'subcategory_id');
    }

    // each subcategory might belongs to an user
    public function addedBy()
    {
        return $this->belongsTo('App\User','addedby_id');
    }

    public function editedBy()
    {
        return $this->belongsTo('App\User','editedby_id');
    }

    // each subcategory might have multiple products
    public function products()
    {
        return $this->hasmany('App\Product','childcategory_id');
    }

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }

}
