<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class SeminarController extends Controller
{
    public function register(){
        return view('frontend.seminar.register');
    }

    public function send(Request $request){

            $validatedData = $request->validate([
                'name' => 'required',
                'designation' => 'required',
                'company_name' => 'required',
                'address' => 'required',
                'conatact_person' => 'required',
                'mobile' => 'required',
                'email' => 'required|email|max:255',
                'message' => 'required',
            ]);

            $data = [
                'name' => $validatedData['name'],
                'designation' => $validatedData['designation'],
                'company_name' => $validatedData['company_name'],
                'address' => $validatedData['address'],
                'conatact_person' => $validatedData['conatact_person'],
                'mobile' => $validatedData['mobile'],
                'email' => $validatedData['email'],
                'message' => $validatedData['message'],
            ];

            \Mail::to('info@tdlcica.com')->send(new \App\Mail\SeminarMail($data));

            return back()->with('success', 'Thanks for register!');
    }

}

