<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class OtherController extends Controller
{
    public function contact(){
        return view('frontend.contacts.index');
    }
    public function uploadCV(){
        return view('frontend.upload-cv.index');
    }



    public function send(Request $request){
            $validatedData = $request->validate([
                'email' => 'required|email|max:255',
                'subject' => 'required',
                'message' => 'required',
            ]);

            $data = [
                'email' => $validatedData['email'],
                'subject' => $validatedData['subject'],
                'message' => $validatedData['message'],
            ];

            \Mail::to('info@tdlcica.com')->send(new \App\Mail\Email($data));

            return back()->with('success', 'Thanks for contacting us!');
    }

    public function sendCV(Request $request){
        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
               @unlink($old_image);
            }
        }

        if ($request->hasFile('file')) {
            $validatedData = $request->validate([
                'name' => 'required|max:255',
                'mobile' => 'required',
                'email' => 'required|email',
                'address' => 'required',
                'subject' => 'required',
                'message' => 'required',
                'file' => 'required|file|mimes:jpeg,png,jpg,gif,svg,ai,psd,pdf,zip,xlsx|max:25600'
            ]);

            // Managing Feature Image
            $file = $request->file('file');

            $fileNameWithExtension = $file->getClientOriginalName();

            //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
            $ModifiedFileNameWithoutExtension = str_slug($validatedData['name'], '_').'_'.md5(microtime());

            $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

            $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


            $save_path=public_path('img/email/');


            if (!file_exists($save_path)) {
                mkdir($save_path, 0777, true);
            }

            $file->move($save_path, $ModifiedFileNameWithExtension);

            $sourceofFile=public_path('img/email').'/'. $ModifiedFileNameWithExtension;

            $data = [
                'name' => $validatedData['name'],
                'email' => $validatedData['email'],
                'mobile' => $validatedData['mobile'],
                'address' => $validatedData['address'],
                'subject' => $validatedData['subject'],
                'message' => $validatedData['message'],
                'file' => $sourceofFile,
            ];



        \Mail::to('info@tdlcica.com')->send(new \App\Mail\SentCV($data));

        UnlinkImage($sourceofFile);

        return back()->with('success', 'Thanks for uploading your CV!');

        }

        if (!$request->hasFile('file')) {
            $validatedData = $request->validate([
                'name' => 'required|max:255',
                'mobile' => 'required',
                'email' => 'required|email',
                'address' => 'required',
                'subject' => 'required',
                'message' => 'required',
            ]);

            $data = [
                'name' => $validatedData['name'],
                'email' => $validatedData['email'],
                'mobile' => $validatedData['mobile'],
                'address' => $validatedData['address'],
                'subject' => $validatedData['subject'],
                'message' => $validatedData['message'],
            ];



        \Mail::to('info@tdlcica.com')->send(new \App\Mail\SentCV($data));

        return back()->with('success', 'Thanks for uploading your CV!');

        }
    }
}

