<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Course;
use App\CourseEvent;
use Carbon\Carbon;

class CourseController extends Controller
{
    /**
     * Show the application homepage.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('frontend.courses.index');
    }

    /**
     * Show the application upcoming courses.
     *
     * @return \Illuminate\Http\Response
     */
    public function ongoing()
    {
        $pageTitle = 'Ongoing Courses';

        $courseEvents = courseEvent::all();

        $courseEvents = $courseEvents->filter(function ($courseEvent, $key) {
            return $courseEvent->start_date <= Carbon::now() && $courseEvent->end_date >= Carbon::now();
        });


        return view('frontend.courses.index',compact('pageTitle','courseEvents'));
    }

    /**
     * Show the application upcoming courses.
     *
     * @return \Illuminate\Http\Response
     */
    public function upcoming()
    {
        $pageTitle = 'Upcoming Courses';

        $courseEvents = CourseEvent::whereDate('start_date','>',now())->get();
        return view('frontend.courses.index',compact('pageTitle','courseEvents'));
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $course
     * @return \Illuminate\Http\Response
     */
    public function show(Course $course)
    {
        return view('frontend.courses.show',compact('course'));
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $course
     * @return \Illuminate\Http\Response
     */
    public function showEvents(Course $course, CourseEvent $courseEvent)
    {
        return view('frontend.courses.courseEvents',compact('course','courseEvent'));
    }


}
