<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Category;
use App\SubCategory;

class SubCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $subcategories = SubCategory::all();
        return view('admin.subcategories.index',compact('subcategories'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::where('hassubcategory',true)->get();
        return view('admin.subcategories.addSubCategories',compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|max:255',
            'description' => 'max:2000',
            'category_id' => 'required|integer',
            'haschildcategory' => 'required|boolean',
            'order' => 'required|integer|max:500',
        ]);


        $subcategory=SubCategory::create([
            'name' => $data['name'],
            'description' => $data['description'] ? $data['description'] : null,
            'category_id' => $data['category_id'],
            'haschildcategory' => $data['haschildcategory'],
            'order' => $data['order'],
            'slug' => str_slug($data['name'], '-'),
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $updatedSubCategory = tap($subcategory)->update([
            'slug' => $subcategory->id . '-' . str_slug($subcategory->name, '-')
        ]);


        return back()->with('success','You have successfully added a SubCategory.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(SubCategory $subcategory)
    {
        $categories = Category::where('hassubcategory',true)->get();
        return view('admin.subcategories.editSubCategories',compact('categories','subcategory'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, SubCategory $subcategory)
    {

        $data = $request->validate([
            'name' => 'required|max:255',
            'description' => 'max:2000',
            'category_id' => 'required|integer',
            'haschildcategory' => 'required|boolean',
            'order' => 'required|integer|max:500',
        ]);


        $subcategory = tap($subcategory)->update([
            'name' => $data['name'],
            'description' => $data['description'] ? $data['description'] : null,
            'category_id' => $data['category_id'],
            'haschildcategory' => $data['haschildcategory'],
            'order' => $data['order'],
            'slug' => $subcategory->id . '-' . str_slug($data['name'], '-'),
            'editedby_id' => \Auth::id(),
        ]);

        return redirect()->route('admin.subcategories')->with('success','You have successfully updated a subcategory.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, SubCategory $subcategory)
    {
        if ($subcategory->delete()) {
            return redirect()->route('admin.subcategories')->with('success','You have successfully deleted a subcategory.');
        }
        return redirect()->back();
    }
}
