<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Page;

class PageController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pages = Page::all();

        return view('admin.pages.index', compact('pages'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.addPages');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'title' => 'required|max:255',
            'subtitle' => 'max:1000',
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'description' => 'required',
            'order' => 'max:999',
            'slug' => 'required|alpha_dash|unique:pages'
        ]);

        $ModifiedFileNameWithExtension ='';

        if ($request->hasFile('image')) {

        // Managing Feature Image
        $file = $request->file('image');

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($validatedData['title'], '_').'_'.md5(microtime());

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


        $save_path=public_path('img/pages/');


        if (!file_exists($save_path)) {
            mkdir($save_path, 0777, true);
        }

        $file->move($save_path, $ModifiedFileNameWithExtension);
        }

        $page=Page::create([
            'title' => $validatedData['title'],
            'subtitle' => $validatedData['subtitle'] ? $validatedData['subtitle'] : 'N/A',
            'image' => $request->hasFile('image') ? $ModifiedFileNameWithExtension : null,
            'order' => $validatedData['order'],
            'description' => $validatedData['description'] ? $validatedData['description'] : 'N/A',
            'slug' => $validatedData['slug']
        ]);


        // $page = tap($page)->update([
        //     'slug' => $page->id . '-' . $page->slug
        // ]);


        return back()
            ->with('success','You have successfully added a Page.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Page $page)
    {
        return view('admin.pages.editPages', compact('page'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Page $page)
    {
        if ($request->hasFile('image')) {
            $validatedData = $request->validate([
            'title' => 'required|max:255',
            'subtitle' => 'max:1000',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'description' => 'required',
            'slug' => 'required|alpha_dash|unique:pages,slug,'.$page->id,
            'order' => 'max:999'
        ]);

        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
               @unlink($old_image);
            }
        }

        UnlinkImage(public_path('img/pages').'\/'.$page->image);

        // Managing Feature Image
        $file = $request->file('image');

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($validatedData['title'], '_').'_'.md5(microtime());

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


        $save_path=public_path('img/pages/');


        if (!file_exists($save_path)) {
            mkdir($save_path, 0777, true);
        }

        $file->move($save_path, $ModifiedFileNameWithExtension);


        $page = tap($page)->update([
            'title' => $validatedData['title'],
            'subtitle' => $validatedData['subtitle']  ? $validatedData['subtitle'] : 'N/A',
            'image' => $ModifiedFileNameWithExtension,
            'order' => $validatedData['order'],
            'description' => $validatedData['description'] ? $validatedData['description'] : 'N/A',
            'slug' => $validatedData['slug']
        ]);

        } else {
            $validatedData = $request->validate([
                'title' => 'required|max:255',
                'subtitle' => 'max:1000',
                'description' => 'required',
                'slug' => 'required|alpha_dash|unique:pages,slug,'.$page->id,
                'order' => 'max:999'
            ]);

            $product = tap($page)->update([
                'title' => $validatedData['title'],
                'subtitle' => $validatedData['subtitle']  ? $validatedData['subtitle'] : 'N/A',
                'order' => $validatedData['order'],
                'description' => $validatedData['description'] ? $validatedData['description'] : 'N/A',
                'slug' => $validatedData['slug']
            ]);
        }


        return redirect()->route('admin.pages.index')->with('success','You have successfully updated a Page.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,Page $page)
    {
        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
               @unlink($old_image);
            }
        }

        UnlinkImage(public_path('img/pages').'\/'.$page->image);

        if ($page->delete()) {
            return redirect()->route('admin.pages.index')->with('success','You have successfully deleted a Page.');
        }
        return redirect()->route('admin.pages.index');
    }
}
