<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\News;

class NewsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $news = News::all();

        return view('admin.news.index', compact('news'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.news.addNews');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $data = $request->validate([
            'title' => 'required|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'shortdescription' => 'required|max:255',
            'longdescription' => 'required',
            'order' => 'required|integer|max:500'
        ]);


        // Managing Feature Image
        $file = $request->file('image');

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($data['title'], '_').'_'.md5(microtime());

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


        $save_path=public_path('img/news/');


        if (!file_exists($save_path)) {
            mkdir($save_path, 0777, true);
        }

        $file->move($save_path, $ModifiedFileNameWithExtension);

        $news=News::create([
            'title' => $data['title'],
            'image' => $ModifiedFileNameWithExtension,
            'excerpt' => $data['shortdescription'],
            'description' => $data['longdescription'],
            'order' => $data['order'],
            'slug' => str_slug($data['title'], '-'),
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $news = tap($news)->update([
            'slug' => str_slug($news->title, '-').'-'.$news->id,
            'order' => $news->id
        ]);


        return back()
            ->with('success','You have successfully added a News.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(News $news)
    {

        return view('admin.news.editNews', compact('news'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, News $news)
    {
        if ($request->hasFile('image')) {
            $data = $request->validate([
            'title' => 'required|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'shortdescription' => 'required|max:255',
            'longdescription' => 'required',
            'order' => 'required|integer|max:500'
        ]);

        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
                @unlink($old_image);
            }
        }

        UnlinkImage(public_path('img/news/').'/'.$news->image);

        // Managing Feature Image
        $file = $request->file('image');

        $fileNameWithExtension = $file->getClientOriginalName();

        //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
        $ModifiedFileNameWithoutExtension = str_slug($data['title'], '_').'_'.md5(microtime());

        $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

        $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


        $save_path=public_path('img/news/');


        if (!file_exists($save_path)) {
            mkdir($save_path, 0777, true);
        }

        $file->move($save_path, $ModifiedFileNameWithExtension);


        $news = tap($news)->update([
            'title' => $data['title'],
            'image' => $ModifiedFileNameWithExtension,
            'excerpt' => $data['shortdescription'],
            'description' => $data['longdescription'],
            'order' => $data['order'],
            'slug' => str_slug($data['title'], '-').'-'.$news->id,
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        } else {
            $data = $request->validate([
                'title' => 'required|max:255',
                'shortdescription' => 'required|max:255',
                'longdescription' => 'required',
                'order' => 'required|integer|max:500'
            ]);

            $news = tap($news)->update([
                'title' => $data['title'],
                'excerpt' => $data['shortdescription'],
                'description' => $data['longdescription'],
                'order' => $data['order'],
                'slug' => str_slug($data['title'], '-').'-'.$news->id,
                'editedby_id' => \Auth::id(),
            ]);
        }

        return redirect()->route('admin.news.index')->with('success','You have successfully updated a News.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,News $news)
    {
        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
               @unlink($old_image);
            }
        }

        UnlinkImage(public_path('img/news/'.'/'.$news->image));

        if ($news->delete()) {
            return redirect()->back()->with('success','You have successfully deleted a news.');;
        }
        return redirect()->route('admin.news.index');
    }

}
