<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\ImportantLink;

class ImportantLinksController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $importantLinks = ImportantLink::all();
        return view('admin.important-links.index',compact('importantLinks'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.important-links.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $this->validate($request, [
        'title' => 'required',
        'url' => 'required'
        ]);
        
        $importantLink = new ImportantLink();
        //On left field name in DB and on right field name in Form/view/request
        $importantLink->title = $request->input('title');
        $importantLink->url = $request->input('url');
        $importantLink->priority = $request->input('priority');
        $importantLink->description = $request->input('description');
        $importantLink->save();
        
        return back()->with('success','You have successfully added a link.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $importantLink = ImportantLink::find($id);
        return view('admin.important-links.edit',compact('importantLink'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
       $this->validate($request, [
        'title' => 'required',
        'url' => 'required'
        ]);
        
        $importantLink = ImportantLink::find($id);
        $importantLink->title = $request->input('title');
        $importantLink->url = $request->input('url');
        $importantLink->priority = $request->input('priority');
        $importantLink->description = $request->input('description');
        $importantLink->update();

        return redirect()->route('admin.important-links.index')->with('success','You have successfully updated a link.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        ImportantLink::find($id)->delete();
        return redirect()->back()->with('success','You have successfully deleted a link.');
    }
}


