<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Gallery;

class GalleryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $galleries = Gallery::all();

        return view('admin.galleries.index', compact('galleries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.galleries.addGalleries');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|max:255',
            'type' => 'required|max:255',
            'excerpt' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'slug' => 'nullable|alpha_dash|unique:galleries',
            'order' => 'required|integer|max:500',

        ]);

         // Managing Feature Image
         $file = $request->file('image');

         $fileNameWithExtension = $file->getClientOriginalName();

         //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
         $ModifiedFileNameWithoutExtension = str_slug($data['title'], '_').'_'.md5(microtime());

         $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

         $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


         $save_path=public_path('img/gallery/'.$data['type']);


         if (!file_exists($save_path)) {
             mkdir($save_path, 0777, true);
         }

         $file->move($save_path, $ModifiedFileNameWithExtension);



        $gallery = Gallery::create([
            'title' => $data['title'],
            'type' => $data['type'],
            'excerpt' => $data['excerpt'],
            'url' => $ModifiedFileNameWithExtension,
            'order' => $data['order'],
            'slug' => !is_null($data['slug']) ? $data['slug'] : str_slug($data['title'], '-'),
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $gallery = tap($gallery)->update([
            'slug' => str_slug($gallery->title, '-') . '-' .$gallery->id
        ]);


        return back()
            ->with('success','You have successfully added a '.$gallery->type.' type image to gallery.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Gallery $gallery)
    {
        return view('admin.galleries.editGalleries', compact('gallery'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Gallery $gallery)
    {
        if ($request->hasFile('image')) {
            $data = $request->validate([
                'title' => 'required|max:255',
                'excerpt' => 'required',
                'type' => 'required|max:255',
                'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'order' => 'required|max:5000',
                'slug' => 'nullable|alpha_dash|unique:galleries,slug,'.$gallery->id,
            ]);


            function UnlinkImage($old_image)
            {
                // $old_image = $filepath.$fileName;
                if (file_exists($old_image)) {
                @unlink($old_image);
                }
            }

            UnlinkImage(public_path('img/gallery/'.$data['type'].'\/'.$gallery->url));

            // Managing Feature Image
            $file = $request->file('image');

            $fileNameWithExtension = $file->getClientOriginalName();

            //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
            $ModifiedFileNameWithoutExtension = str_slug($data['title'], '_').'_'.md5(microtime());

            $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

            $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


            $save_path=public_path('img/gallery/'.$data['type']);


            if (!file_exists($save_path)) {
                mkdir($save_path, 0777, true);
            }

              $file->move($save_path, $ModifiedFileNameWithExtension);

            $gallery = tap($gallery)->update([
                'title' => $data['title'],
                'type' => $data['type'],
                'excerpt' => $data['excerpt'],
                'url' => $ModifiedFileNameWithExtension,
                'order' => $data['order'],
                'slug' => !is_null($data['slug']) ? $data['slug'] : str_slug($gallery->title, '-') . '-' .$gallery->id,
                'editedby_id' => \Auth::id(),
            ]);

        } else {
            $data = $request->validate([
                'title' => 'required|max:255',
                'type' => 'required|max:255',
                'excerpt' => 'required',
                'order' => 'required|max:299',
                'slug' => 'nullable|alpha_dash|unique:galleries,slug,'.$gallery->id,
            ]);


            $gallery = tap($gallery)->update([
                'title' => $data['title'],
                'type' => $data['type'],
                'excerpt' => $data['excerpt'],
                'slug' => !is_null($data['slug']) ? $data['slug'] : str_slug($gallery->title, '-') . '-' .$gallery->id,
                'order' => $data['order']
            ]);
        }

        return redirect()->route('admin.galleries.index')->with('success','You have successfully updated a '.$gallery->type.' type image to gallery.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,Gallery $gallery)
    {
        function UnlinkImage($old_image)
        {
            // $old_image = $filepath.$fileName;
            if (file_exists($old_image)) {
               @unlink($old_image);
            }
        }

        UnlinkImage(public_path('img/gallery/'.$gallery->type.'\/'.$gallery->url));

        if ($gallery->delete()) {
            return redirect()->back()->with('success','You have successfully deleted a Gallery image.');;
        }
        return redirect()->route('admin.galleries.index');
    }
}
