<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Course;
use App\CourseEvent;
use App\CourseTrainer;
use App\CourseSchedule;

class CourseTrainerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $courseTrainers = CourseTrainer::all();
        return view('admin.coursetrainers.index',compact('courseTrainers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.coursetrainers.addCourseTrainer');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'mobile' => 'nullable',
            'email' => 'nullable|email',
            'photo' => 'nullable|image|max:2048',
        ]);
        
        if($request->hasFile('photo')){
            $file = $request->file('photo');
    
            $fileNameWithExtension = $file->getClientOriginalName();
    
            //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
            $ModifiedFileNameWithoutExtension = str_slug($data['name'], '_').'_'.md5(microtime());
    
            $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);
    
            $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;
    
    
            $save_path=public_path('img/courses/trainer/');
    
    
            if (!file_exists($save_path)) {
                mkdir($save_path, 0777, true);
            }
    
            $file->move($save_path, $ModifiedFileNameWithExtension);
        }



        $courseTrainer = CourseTrainer::create([
            'name' => $data['name'],
            'mobile' => isset($data['mobile']) ? $data['mobile'] : null,
            'email' => isset($data['email']) ? $data['email'] : null,
            'photo' => $request->hasFile('photo') ? $ModifiedFileNameWithExtension : null,
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        return back()->with('success','You have successfully added a course trainer.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(CourseTrainer $courseTrainer)
    {
        return view('admin.coursetrainers.editCourseTrainer',compact('courseTrainer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CourseTrainer $courseTrainer)
    {
        $data = $request->validate([
            'name' => 'required',
            'mobile' => 'nullable',
            'email' => 'nullable|email',
            'photo' => 'nullable|image|max:2048',
        ]);
        if ($request->hasFile('photo')) {

            function UnlinkImage($old_image)
            {
                // $old_image = $filepath.$fileName;
                if (file_exists($old_image)) {
                    @unlink($old_image);
                }
            }

            UnlinkImage(public_path('img/courses/trainer').'/'.$courseTrainer->photo);

            // Managing Feature Image
            $file = $request->file('photo');

            $fileNameWithExtension = $file->getClientOriginalName();

            //$fileName = pathinfo($fileNameWithExtension, PATHINFO_FILENAME);
            $ModifiedFileNameWithoutExtension = str_slug($data['name'], '_').'_'.md5(microtime());

            $fileExtension = pathinfo($fileNameWithExtension, PATHINFO_EXTENSION);

            $ModifiedFileNameWithExtension = $ModifiedFileNameWithoutExtension.'.'.$fileExtension;


            $save_path=public_path('img/courses/trainer/');


            if (!file_exists($save_path)) {
                mkdir($save_path, 0777, true);
            }

            $file->move($save_path, $ModifiedFileNameWithExtension);
        }

            $courseTrainer = tap($courseTrainer)->update([
                'name' => $data['name'],
                'mobile' => isset($data['mobile']) ? $data['mobile'] : null,
                'email' => isset($data['email']) ? $data['email'] : null,
                'photo' => $request->hasFile('photo') ? $ModifiedFileNameWithExtension : null,
                'editedby_id' => \Auth::id(),
            ]);

        return redirect()->route('admin.coursetrainers.index')->with('success','You have successfully updated a course trainer information.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, CourseTrainer $courseTrainer)
    {
        if ($courseTrainer->delete()) {
            function UnlinkImage($old_image)
            {
                // $old_image = $filepath.$fileName;
                if (file_exists($old_image)) {
                    @unlink($old_image);
                }
            }

            UnlinkImage(public_path('img/courses/trainer').'/'.$courseTrainer->photo);

            return redirect()->route('admin.coursetrainers.index')->with('success','You have successfully deleted a course trainer.');
        }
        return redirect()->back();
    }
}


