<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Course;
use App\CourseEvent;
use App\CourseSchedule;
use App\CourseTrainer;

class CourseEventController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $courses = DB::table('courses')->get();
        $courseEvents = CourseEvent::with('course')->orderBy('order')->get();
        return view('admin.courseevents.index',compact('courseEvents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $courses = Course::orderBy('order')->get();
        $courseTrainers=CourseTrainer::all();
        return view('admin.courseevents.addCourseEvent',compact('courses','courseTrainers'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'course_id' => 'required|integer',
            'total_hours' => 'required|numeric',
            'total_seat' => 'required|numeric',
            'total_no_of_class' => 'required|numeric',
            'instructor_id' => 'required|numeric',
            'start_date' => 'required|date',
            'end_date' => 'required|date',
            'last_date_of_reg' => 'required|date',
            "schedule"    => "required|array|min:3",
            'venue' => 'required',
            'order' => 'required|integer|max:500',
        ]);




        $courseEvent = CourseEvent::create([
            'course_id' => $data['course_id'],
            'total_hours' => $data['total_hours'],
            'total_seat' => $data['total_seat'],
            'total_no_of_class' => $data['total_no_of_class'],
            'start_date' => $data['start_date'],
            'end_date' => $data['end_date'],
            'last_date_of_reg' => $data['last_date_of_reg'],
            'venue' => $data['venue'],
            'instructor_id'=> $data['instructor_id'],
            'order' => $data['order'],
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $courseEvent = tap($courseEvent)->update([
            'order' => $courseEvent->id
        ]);

        $collectDay = collect($data['schedule']['day']);
        $collectStartTime = collect($data['schedule']['start_time']);
        $collectEndTime = collect($data['schedule']['end_time']);

        $convertCollectedStartTime = $collectStartTime->map(function ($item, $key) {
            return date("g:i a", strtotime($item));
        });
        $convertCollectedEndTime = $collectEndTime->map(function ($item, $key) {
            return date("g:i a", strtotime($item));
        });


        for ($i = 0; $i < count($collectDay); $i++) {
            $courseSchedule=CourseSchedule::create([
                'course_events_id'=> $courseEvent->id,
                'day' => $collectDay[$i],
                'start_time' => $collectStartTime[$i],
                'end_time' => $collectEndTime[$i],
                'order' => $data['order'],
                'addedby_id' => \Auth::id(),
                'editedby_id' => \Auth::id()
            ]);
        }

        return back()->with('success','You have successfully added a course event.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(CourseEvent $courseEvent)
    {
        $courses = Course::orderBy('order')->get();
        $courseTrainers=CourseTrainer::all();
        return view('admin.courseevents.editCourseEvent',compact('courseEvent','courses','courseTrainers'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CourseEvent $courseEvent)
    {
            $data = $request->validate([
                'course_id' => 'required|integer',
                'total_hours' => 'required|numeric',
                'total_seat' => 'required|numeric',
                'total_no_of_class' => 'required|numeric',
                'instructor_id' => 'required|numeric',
                'start_date' => 'required|date',
                'end_date' => 'required|date',
                'last_date_of_reg' => 'required|date',
                "schedule"    => "required|array|min:3",
                'venue' => 'required',
                'order' => 'required|integer|max:500',
            ]);


            $courseEvent = tap($courseEvent)->update([
                'course_id' => $data['course_id'],
                'total_hours' => $data['total_hours'],
                'total_seat' => $data['total_seat'],
                'total_no_of_class' => $data['total_no_of_class'],
                'start_date' => $data['start_date'],
                'end_date' => $data['end_date'],
                'last_date_of_reg' => $data['last_date_of_reg'],
                'venue' => $data['venue'],
                'instructor_id'=> $data['instructor_id'],
                'order' => $data['order'],
                'editedby_id' => \Auth::id(),
            ]);

            $collectDay = collect($data['schedule']['day']);
            $collectStartTime = collect($data['schedule']['start_time']);
            $collectEndTime = collect($data['schedule']['end_time']);

            $convertCollectedStartTime = $collectStartTime->map(function ($item, $key) {
                return date("g:i a", strtotime($item));
            });

            $convertCollectedEndTime = $collectEndTime->map(function ($item, $key) {
                return date("g:i a", strtotime($item));
            });

            $courseEvent->schedules()->delete();

            for ($i = 0; $i < count($collectDay); $i++) {
                $courseSchedule=CourseSchedule::create([
                    'course_events_id'=> $courseEvent->id,
                    'day' => $collectDay[$i],
                    'start_time' => $collectStartTime[$i],
                    'end_time' => $collectEndTime[$i],
                    'order' => $data['order'],
                    'addedby_id' => \Auth::id(),
                    'editedby_id' => \Auth::id()
                ]);
            }

        return redirect()->route('admin.courseEvents.index')->with('success','You have successfully updated a course event.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, CourseEvent $courseEvent)
    {
        if ($courseEvent->delete()) {
            return redirect()->route('admin.courseEvents.index')->with('success','You have successfully deleted a course event.');
        }
        return redirect()->back();
    }
}


