<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Brand;

class BrandController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $brands = Brand::all();
        return view('admin.brands.index',compact('brands'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    return view('admin.brands.addBrands');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data = $request->validate([
            'name' => 'required|max:255',
            'order' => 'required|integer|max:10000',
        ]);


        $brand=Brand::create([
            'name' => $data['name'],
            'slug' => str_slug($data['name'], '-'),
            'order' => $data['order'],
            'addedby_id' => \Auth::id(),
            'editedby_id' => \Auth::id(),
        ]);

        $brand = tap($brand)->update([
            'slug' => $brand->id . '-' . $data['name']
        ]);


        return back()->with('success','You have successfully added a brand.');

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Brand $brand)
    {
        return view('admin.brands.editBrands',compact('brand'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Brand $brand)
    {

        $data = $request->validate([
            'name' => 'required|max:255',
            'order' => 'required|integer|max:10000',
        ]);


        $brands = tap($brand)->update([
            'name' => $data['name'],
            'order' => $data['order'],
            'slug' => str_slug($data['name'], '-'),
            'editedby_id' => \Auth::id(),
        ]);

        return redirect()->route('admin.brands')->with('success','You have successfully updated a brand.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, Brand $brand)
    {
        if ($brand->delete()) {
            return redirect()->route('admin.brands')->with('success','You have successfully deleted a Brand.');
        }
        return redirect()->back();
    }
}


