<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class CourseSchedule extends Model
{
    protected $guarded = [];

    public function courseEvent()
    {
        return $this->belongsTo('App\CourseEvent','course_events_id');
    }


    /**
     * convert to H:i:s to H:i.
     *
     * @return string
     */
    public function to24H($value)
    {
        return Carbon::parse($value)->format('H:i');
    }

    /**
     * convert to H:i:s to H:i a.
     *
     * @return string
     */
    public function to12H($value)
    {
        return Carbon::parse($value)->format('h:i a');
    }

    /**
     * Get the course schedule's start time attribute
     *
     * @param  string  $value
     * @return string
     */
    public function getStartTimeAttribute($value)
    {
        return Carbon::parse($value);
    }

    /**
     * Get the course schedule's start time attribute
     *
     * @param  string  $value
     * @return string
     */
    public function getEndTimeAttribute($value)
    {
        return Carbon::parse($value);
    }

}
