<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CourseEvent extends Model
{
    protected $guarded = [];

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = [
        'start_date',
        'end_date',
        'last_date_of_reg',
        'created_at',
        'updated_at'
    ];

    // each courses might belongs to an user
    public function addedBy()
    {
        return $this->belongsTo('App\User','addedby_id');
    }

    public function editedBy()
    {
        return $this->belongsTo('App\User','editedby_id');
    }

    public function course()
    {
        return $this->belongsTo('App\Course','course_id');
    }

    public function courseTrainer()
    {
        return $this->belongsTo('App\CourseTrainer','instructor_id');
    }


    // each course event might have multiple schedules
    public function schedules()
    {
        return $this->hasmany('App\CourseSchedule','course_events_id');
    }

}
